/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb.impl;

import com.mongodb.MongoException;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.naming.NamingHelper;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.Namespace;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Index;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.UniqueKey;
import org.hibernate.ogm.datastore.mongodb.impl.MongoDBDatastoreProvider;
import org.hibernate.ogm.datastore.mongodb.index.impl.MongoDBIndexSpec;
import org.hibernate.ogm.datastore.mongodb.index.impl.MongoDBIndexType;
import org.hibernate.ogm.datastore.mongodb.logging.impl.Log;
import org.hibernate.ogm.datastore.mongodb.logging.impl.LoggerFactory;
import org.hibernate.ogm.datastore.spi.BaseSchemaDefiner;
import org.hibernate.ogm.datastore.spi.DatastoreProvider;
import org.hibernate.ogm.datastore.spi.SchemaDefiner;
import org.hibernate.ogm.model.key.spi.AssociationKeyMetadata;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.model.key.spi.IdSourceKeyMetadata;
import org.hibernate.ogm.options.shared.impl.IndexOptionsOption;
import org.hibernate.ogm.options.shared.spi.IndexOption;
import org.hibernate.ogm.options.shared.spi.IndexOptions;
import org.hibernate.ogm.options.spi.OptionsService;
import org.hibernate.ogm.persister.impl.OgmEntityPersister;
import org.hibernate.ogm.util.impl.Contracts;
import org.hibernate.ogm.util.impl.StringHelper;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.tool.hbm2ddl.UniqueConstraintSchemaUpdateStrategy;

public class MongoDBSchemaDefiner
extends BaseSchemaDefiner {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    private static final int INDEX_CREATION_ERROR_CODE = 85;
    private List<MongoDBIndexSpec> indexSpecs = new ArrayList<MongoDBIndexSpec>();

    public void validateMapping(SchemaDefiner.SchemaDefinitionContext context) {
        this.validateGenerators(context.getAllIdSourceKeyMetadata());
        this.validateEntityCollectionNames(context.getAllEntityKeyMetadata());
        this.validateAssociationNames(context.getAllAssociationKeyMetadata());
        this.validateAllPersisters(context.getSessionFactory().getEntityPersisters().values());
        this.validateIndexSpecs(context);
    }

    public void initializeSchema(SchemaDefiner.SchemaDefinitionContext context) {
        SessionFactoryImplementor sessionFactoryImplementor = context.getSessionFactory();
        ServiceRegistryImplementor registry = sessionFactoryImplementor.getServiceRegistry();
        MongoDBDatastoreProvider provider = (MongoDBDatastoreProvider)registry.getService(DatastoreProvider.class);
        for (MongoDBIndexSpec indexSpec : this.indexSpecs) {
            this.createIndex(provider.getDatabase(), indexSpec);
        }
    }

    private void validateAllPersisters(Iterable<EntityPersister> persisters) {
        for (EntityPersister persister : persisters) {
            if (!(persister instanceof OgmEntityPersister)) continue;
            OgmEntityPersister ogmPersister = (OgmEntityPersister)persister;
            int propertySpan = ogmPersister.getEntityMetamodel().getPropertySpan();
            for (int i = 0; i < propertySpan; ++i) {
                String[] columnNames;
                for (String columnName : columnNames = ogmPersister.getPropertyColumnNames(i)) {
                    this.validateAsMongoDBFieldName(columnName);
                }
            }
        }
    }

    private void validateAssociationNames(Iterable<AssociationKeyMetadata> allAssociationKeyMetadata) {
        for (AssociationKeyMetadata associationKeyMetadata : allAssociationKeyMetadata) {
            MongoDBSchemaDefiner.validateAsMongoDBCollectionName(associationKeyMetadata.getTable());
            for (String column : associationKeyMetadata.getRowKeyColumnNames()) {
                this.validateAsMongoDBFieldName(column);
            }
        }
    }

    private void validateEntityCollectionNames(Iterable<EntityKeyMetadata> allEntityKeyMetadata) {
        for (EntityKeyMetadata entityKeyMetadata : allEntityKeyMetadata) {
            MongoDBSchemaDefiner.validateAsMongoDBCollectionName(entityKeyMetadata.getTable());
            for (String column : entityKeyMetadata.getColumnNames()) {
                this.validateAsMongoDBFieldName(column);
            }
        }
    }

    private void validateGenerators(Iterable<IdSourceKeyMetadata> allIdSourceKeyMetadata) {
        for (IdSourceKeyMetadata idSourceKeyMetadata : allIdSourceKeyMetadata) {
            String keyColumn = idSourceKeyMetadata.getKeyColumnName();
            if (keyColumn.equals("_id")) continue;
            log.cannotUseGivenPrimaryKeyColumnName(keyColumn, "_id");
        }
    }

    private void validateIndexSpecs(SchemaDefiner.SchemaDefinitionContext context) {
        OptionsService optionsService = (OptionsService)context.getSessionFactory().getServiceRegistry().getService(OptionsService.class);
        Map tableEntityTypeMapping = context.getTableEntityTypeMapping();
        Database database = context.getDatabase();
        UniqueConstraintSchemaUpdateStrategy constraintMethod = UniqueConstraintSchemaUpdateStrategy.interpret((Object)context.getSessionFactory().getProperties().get("hibernate.schema_update.unique_constraint_strategy"));
        if (constraintMethod == UniqueConstraintSchemaUpdateStrategy.SKIP) {
            log.tracef("Skipping generation of unique constraints", new Object[0]);
        }
        for (Namespace namespace : database.getNamespaces()) {
            for (Table table : namespace.getTables()) {
                Class entityType;
                if (!table.isPhysicalTable() || (entityType = (Class)tableEntityTypeMapping.get(table.getName())) == null) continue;
                IndexOptions indexOptions = this.getIndexOptions(optionsService, entityType);
                HashSet<String> forIndexNotReferenced = new HashSet<String>(indexOptions.getReferencedIndexes());
                this.validateIndexSpecsForUniqueColumns(table, indexOptions, forIndexNotReferenced, constraintMethod);
                this.validateIndexSpecsForUniqueKeys(table, indexOptions, forIndexNotReferenced, constraintMethod);
                this.validateIndexSpecsForIndexes(table, indexOptions, forIndexNotReferenced);
                for (String forIndex : forIndexNotReferenced) {
                    log.indexOptionReferencingNonExistingIndex(table.getName(), forIndex);
                }
            }
        }
    }

    private void validateIndexSpecsForUniqueColumns(Table table, IndexOptions indexOptions, Set<String> forIndexNotReferenced, UniqueConstraintSchemaUpdateStrategy constraintMethod) {
        Iterator columnIterator = table.getColumnIterator();
        while (columnIterator.hasNext()) {
            MongoDBIndexSpec indexSpec;
            Column column = (Column)columnIterator.next();
            if (!column.isUnique()) continue;
            String indexName = NamingHelper.INSTANCE.generateHashedConstraintName("UK_", table.getNameIdentifier(), new Identifier[]{Identifier.toIdentifier((String)column.getName())});
            forIndexNotReferenced.remove(indexName);
            if (constraintMethod == UniqueConstraintSchemaUpdateStrategy.SKIP || !this.validateIndexSpec(indexSpec = new MongoDBIndexSpec(table.getName(), column.getName(), indexName, this.getIndexOptionDocument(table, indexOptions.getOptionForIndex(indexName))))) continue;
            this.indexSpecs.add(indexSpec);
        }
    }

    private void validateIndexSpecsForUniqueKeys(Table table, IndexOptions indexOptions, Set<String> forIndexNotReferenced, UniqueConstraintSchemaUpdateStrategy constraintMethod) {
        Iterator keys = table.getUniqueKeyIterator();
        while (keys.hasNext()) {
            MongoDBIndexSpec indexSpec;
            UniqueKey uniqueKey = (UniqueKey)keys.next();
            forIndexNotReferenced.remove(uniqueKey.getName());
            if (constraintMethod == UniqueConstraintSchemaUpdateStrategy.SKIP || !this.validateIndexSpec(indexSpec = new MongoDBIndexSpec(uniqueKey, this.getIndexOptionDocument(table, indexOptions.getOptionForIndex(uniqueKey.getName()))))) continue;
            this.indexSpecs.add(indexSpec);
        }
    }

    private void validateIndexSpecsForIndexes(Table table, IndexOptions indexOptions, Set<String> forIndexNotReferenced) {
        Iterator indexes = table.getIndexIterator();
        while (indexes.hasNext()) {
            Index index = (Index)indexes.next();
            forIndexNotReferenced.remove(index.getName());
            MongoDBIndexSpec indexSpec = new MongoDBIndexSpec(index, this.getIndexOptionDocument(table, indexOptions.getOptionForIndex(index.getName())));
            if (!this.validateIndexSpec(indexSpec)) continue;
            this.indexSpecs.add(indexSpec);
        }
    }

    private Document getIndexOptionDocument(Table table, IndexOption indexOption) {
        try {
            Document options = StringHelper.isNullOrEmptyString((Object)indexOption.getOptions()) ? new Document() : Document.parse((String)indexOption.getOptions());
            options.put("name", (Object)indexOption.getTargetIndexName());
            return options;
        }
        catch (Exception e) {
            throw log.invalidOptionsFormatForIndex(table.getName(), indexOption.getTargetIndexName(), e);
        }
    }

    private IndexOptions getIndexOptions(OptionsService optionsService, Class<?> entityType) {
        IndexOptions options = (IndexOptions)optionsService.context().getEntityOptions(entityType).getUnique(IndexOptionsOption.class);
        if (options == null) {
            options = new IndexOptions();
        }
        return options;
    }

    private boolean validateIndexSpec(MongoDBIndexSpec indexSpec) {
        boolean valid = true;
        if (StringHelper.isNullOrEmptyString((Object)indexSpec.getIndexName())) {
            log.indexNameIsEmpty(indexSpec.getCollection());
            valid = false;
        }
        if (indexSpec.getIndexKeysDocument().keySet().isEmpty()) {
            log.noValidKeysForIndex(indexSpec.getCollection(), indexSpec.getIndexName());
            valid = false;
        }
        return valid;
    }

    public void createIndex(MongoDatabase database, MongoDBIndexSpec indexSpec) {
        MongoCollection collection = database.getCollection(indexSpec.getCollection());
        Map<String, Document> preexistingIndexes = this.getIndexes((MongoCollection<Document>)collection);
        String preexistingTextIndex = this.getPreexistingTextIndex(preexistingIndexes);
        if (MongoDBIndexType.TEXT.equals((Object)indexSpec.getIndexType()) && preexistingTextIndex != null && !preexistingTextIndex.equalsIgnoreCase(indexSpec.getIndexName())) {
            throw log.unableToCreateTextIndex(collection.getNamespace().getCollectionName(), indexSpec.getIndexName(), preexistingTextIndex);
        }
        try {
            collection.createIndex((Bson)indexSpec.getIndexKeysDocument(), indexSpec.getOptions());
        }
        catch (MongoException e) {
            String indexName = indexSpec.getIndexName();
            if (e.getCode() == 85 && !StringHelper.isNullOrEmptyString((Object)indexName) && preexistingIndexes.containsKey(indexName)) {
                collection.dropIndex(indexName);
                collection.createIndex((Bson)indexSpec.getIndexKeysDocument(), indexSpec.getOptions());
            }
            throw log.unableToCreateIndex(collection.getNamespace().getCollectionName(), indexName, (Exception)((Object)e));
        }
    }

    private Map<String, Document> getIndexes(MongoCollection<Document> collection) {
        HashMap<String, Document> indexMap = new HashMap<String, Document>();
        for (Document index : collection.listIndexes()) {
            indexMap.put(index.get((Object)"name").toString(), index);
        }
        return indexMap;
    }

    private String getPreexistingTextIndex(Map<String, Document> preexistingIndexes) {
        for (Map.Entry<String, Document> indexEntry : preexistingIndexes.entrySet()) {
            Document keys = (Document)indexEntry.getValue().get((Object)"key");
            if (keys == null || !keys.containsKey((Object)"_fts")) continue;
            return indexEntry.getKey();
        }
        return null;
    }

    private static void validateAsMongoDBCollectionName(String collectionName) {
        Contracts.assertStringParameterNotEmpty((String)collectionName, (String)"requestedName");
        if (collectionName.startsWith("system.")) {
            throw log.collectionNameHasInvalidSystemPrefix(collectionName);
        }
        if (collectionName.contains("\u0000")) {
            throw log.collectionNameContainsNULCharacter(collectionName);
        }
        if (collectionName.contains("$")) {
            throw log.collectionNameContainsDollarCharacter(collectionName);
        }
    }

    private void validateAsMongoDBFieldName(String fieldName) {
        if (fieldName.startsWith("$")) {
            throw log.fieldNameHasInvalidDollarPrefix(fieldName);
        }
        if (fieldName.contains("\u0000")) {
            throw log.fieldNameContainsNULCharacter(fieldName);
        }
    }
}

