/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb.query.parsing.nativequery.impl;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.ogm.datastore.mongodb.query.impl.MongoDBQueryDescriptor;
import org.hibernate.ogm.util.impl.StringHelper;

public class MongoDBQueryDescriptorBuilder {
    private String collection;
    private MongoDBQueryDescriptor.Operation operation;
    private String criteria;
    private String projection;
    private String orderBy;
    private String updateOrInsert;
    private String options;
    private Set<Integer> parsed = new HashSet<Integer>();
    private List<DBObject> pipeline = new ArrayList<DBObject>();
    private Deque<StackedOperation> stack = new ArrayDeque<StackedOperation>();

    public boolean setCollection(String collection) {
        this.collection = collection.trim();
        return true;
    }

    public boolean setOperation(MongoDBQueryDescriptor.Operation operation) {
        this.operation = operation;
        return true;
    }

    public boolean setCriteria(String criteria) {
        this.criteria = criteria;
        return true;
    }

    public boolean setProjection(String projection) {
        this.projection = projection;
        return true;
    }

    public boolean setOrderBy(String orderBy) {
        this.orderBy = orderBy;
        return true;
    }

    public boolean setOptions(String options) {
        this.options = options;
        return true;
    }

    public boolean setUpdateOrInsert(String updateOrInsert) {
        this.updateOrInsert = updateOrInsert;
        return true;
    }

    public MongoDBQueryDescriptor build() {
        if (this.operation != MongoDBQueryDescriptor.Operation.AGGREGATE_PIPELINE) {
            return new MongoDBQueryDescriptor(this.collection, this.operation, this.parse(this.criteria), this.parse(this.projection), this.parse(this.orderBy), this.parse(this.options), this.parse(this.updateOrInsert), null);
        }
        return new MongoDBQueryDescriptor(this.collection, this.operation, this.pipeline);
    }

    private DBObject parse(String json) {
        return (DBObject)MongoDBQueryDescriptorBuilder.parseAsObject(json);
    }

    private static Object parseAsObject(String json) {
        if (StringHelper.isNullOrEmptyString((Object)json)) {
            return null;
        }
        BasicDBObject object = BasicDBObject.parse((String)("{ 'json': " + json + "}"));
        return object.get("json");
    }

    private static DBObject operation(StackedOperation operation, String value) {
        BasicDBObject stage = new BasicDBObject();
        stage.put(MongoDBQueryDescriptorBuilder.normalize(operation), MongoDBQueryDescriptorBuilder.parseAsObject(value));
        return stage;
    }

    public boolean addPipeline(StackedOperation operation, String value) {
        if (!this.parsed.contains(operation.getIndex())) {
            this.parsed.add(operation.getIndex());
            this.pipeline.add(MongoDBQueryDescriptorBuilder.operation(operation, value));
        }
        return true;
    }

    private static String normalize(StackedOperation operation) {
        return operation.getOperation().replaceAll("'", "").replaceAll("\"", "").trim();
    }

    public boolean push(int index, String match) {
        this.stack.push(new StackedOperation(index, match));
        return true;
    }

    public StackedOperation pop() {
        return this.stack.pop();
    }

    private static class StackedOperation {
        private final int index;
        private final String operation;

        public StackedOperation(int index, String operation) {
            this.index = index;
            this.operation = operation;
        }

        public int getIndex() {
            return this.index;
        }

        public String getOperation() {
            return this.operation;
        }
    }

    public static class PipelineOperation {
        private final String command;
        private final String value;

        public PipelineOperation(String command, String value) {
            this.command = command;
            this.value = value;
        }

        public String getCommand() {
            return this.command;
        }

        public String getValue() {
            return this.value;
        }
    }
}

