/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb.index.impl;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Index;
import org.hibernate.mapping.UniqueKey;

public class MongoDBIndexSpec {
    private String collection;
    private String indexName;
    private DBObject indexKeys = new BasicDBObject();
    private DBObject options;
    private boolean isTextIndex = false;

    public MongoDBIndexSpec(String collection, String columnName, String indexName, DBObject options) {
        this.options = this.prepareOptions(options, indexName, true);
        this.collection = collection;
        this.indexName = indexName;
        this.indexKeys.put(columnName, (Object)1);
    }

    public MongoDBIndexSpec(UniqueKey uniqueKey, DBObject options) {
        this.options = this.prepareOptions(options, uniqueKey.getName(), true);
        this.collection = uniqueKey.getTable().getName();
        this.indexName = uniqueKey.getName();
        this.addIndexKeys(uniqueKey.getColumnIterator(), uniqueKey.getColumnOrderMap());
    }

    public MongoDBIndexSpec(Index index, DBObject options) {
        this.options = this.prepareOptions(options, index.getName(), false);
        this.collection = index.getTable().getName();
        this.indexName = index.getName();
        this.addIndexKeys(index.getColumnIterator(), Collections.emptyMap());
    }

    private DBObject prepareOptions(DBObject options, String indexName, boolean unique) {
        options.put("name", (Object)indexName);
        if (unique) {
            options.put("unique", (Object)true);
            if (!options.containsField("partialFilterExpression")) {
                options.put("sparse", (Object)true);
            }
        }
        if (Boolean.TRUE.equals(options.get("text"))) {
            this.isTextIndex = true;
            options.removeField("text");
        }
        return options;
    }

    public String getCollection() {
        return this.collection;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public boolean isTextIndex() {
        return this.isTextIndex;
    }

    private void addIndexKeys(Iterator<Column> columnIterator, Map<Column, String> columnOrderMap) {
        while (columnIterator.hasNext()) {
            Object mongoDBOrder;
            Column column = columnIterator.next();
            if (this.isTextIndex) {
                mongoDBOrder = "text";
            } else {
                String order = columnOrderMap.get(column) != null ? columnOrderMap.get(column) : "asc";
                mongoDBOrder = "asc".equals(order) ? 1 : -1;
            }
            this.indexKeys.put(column.getName(), mongoDBOrder);
        }
    }

    public DBObject getOptions() {
        return this.options;
    }

    public DBObject getIndexKeysDBObject() {
        return this.indexKeys;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("[");
        sb.append("collection: ").append(this.collection).append(", ");
        sb.append("indexName: ").append(this.indexName);
        sb.append("]");
        return sb.toString();
    }
}

