/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb;

import com.mongodb.AggregationOutput;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.DuplicateKeyException;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bson.types.ObjectId;
import org.hibernate.HibernateException;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.ogm.datastore.document.association.spi.impl.DocumentHelpers;
import org.hibernate.ogm.datastore.document.impl.DotPatternMapHelpers;
import org.hibernate.ogm.datastore.document.impl.EmbeddableStateFinder;
import org.hibernate.ogm.datastore.document.options.AssociationStorageType;
import org.hibernate.ogm.datastore.document.options.spi.AssociationStorageOption;
import org.hibernate.ogm.datastore.map.impl.MapTupleSnapshot;
import org.hibernate.ogm.datastore.mongodb.dialect.impl.AssociationStorageStrategy;
import org.hibernate.ogm.datastore.mongodb.dialect.impl.MongoDBAssociationSnapshot;
import org.hibernate.ogm.datastore.mongodb.dialect.impl.MongoDBTupleSnapshot;
import org.hibernate.ogm.datastore.mongodb.dialect.impl.MongoHelpers;
import org.hibernate.ogm.datastore.mongodb.impl.MongoDBDatastoreProvider;
import org.hibernate.ogm.datastore.mongodb.logging.impl.Log;
import org.hibernate.ogm.datastore.mongodb.logging.impl.LoggerFactory;
import org.hibernate.ogm.datastore.mongodb.options.AssociationDocumentStorageType;
import org.hibernate.ogm.datastore.mongodb.options.impl.AssociationDocumentStorageOption;
import org.hibernate.ogm.datastore.mongodb.options.impl.ReadPreferenceOption;
import org.hibernate.ogm.datastore.mongodb.options.impl.WriteConcernOption;
import org.hibernate.ogm.datastore.mongodb.query.impl.MongoDBQueryDescriptor;
import org.hibernate.ogm.datastore.mongodb.query.parsing.nativequery.impl.MongoDBQueryDescriptorBuilder;
import org.hibernate.ogm.datastore.mongodb.query.parsing.nativequery.impl.NativeQueryParser;
import org.hibernate.ogm.datastore.mongodb.type.impl.ByteStringType;
import org.hibernate.ogm.datastore.mongodb.type.impl.ObjectIdGridType;
import org.hibernate.ogm.datastore.mongodb.type.impl.StringAsObjectIdGridType;
import org.hibernate.ogm.datastore.mongodb.type.impl.StringAsObjectIdType;
import org.hibernate.ogm.dialect.batch.spi.BatchableGridDialect;
import org.hibernate.ogm.dialect.batch.spi.InsertOrUpdateAssociationOperation;
import org.hibernate.ogm.dialect.batch.spi.InsertOrUpdateTupleOperation;
import org.hibernate.ogm.dialect.batch.spi.Operation;
import org.hibernate.ogm.dialect.batch.spi.OperationsQueue;
import org.hibernate.ogm.dialect.batch.spi.RemoveAssociationOperation;
import org.hibernate.ogm.dialect.batch.spi.RemoveTupleOperation;
import org.hibernate.ogm.dialect.identity.spi.IdentityColumnAwareGridDialect;
import org.hibernate.ogm.dialect.multiget.spi.MultigetGridDialect;
import org.hibernate.ogm.dialect.optimisticlock.spi.OptimisticLockingAwareGridDialect;
import org.hibernate.ogm.dialect.query.spi.BackendQuery;
import org.hibernate.ogm.dialect.query.spi.ClosableIterator;
import org.hibernate.ogm.dialect.query.spi.NoOpParameterMetadataBuilder;
import org.hibernate.ogm.dialect.query.spi.ParameterMetadataBuilder;
import org.hibernate.ogm.dialect.query.spi.QueryableGridDialect;
import org.hibernate.ogm.dialect.spi.AssociationContext;
import org.hibernate.ogm.dialect.spi.AssociationTypeContext;
import org.hibernate.ogm.dialect.spi.BaseGridDialect;
import org.hibernate.ogm.dialect.spi.DuplicateInsertPreventionStrategy;
import org.hibernate.ogm.dialect.spi.ModelConsumer;
import org.hibernate.ogm.dialect.spi.NextValueRequest;
import org.hibernate.ogm.dialect.spi.TupleAlreadyExistsException;
import org.hibernate.ogm.dialect.spi.TupleContext;
import org.hibernate.ogm.model.key.spi.AssociationKey;
import org.hibernate.ogm.model.key.spi.AssociationKeyMetadata;
import org.hibernate.ogm.model.key.spi.AssociationKind;
import org.hibernate.ogm.model.key.spi.AssociationType;
import org.hibernate.ogm.model.key.spi.EntityKey;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.model.key.spi.IdSourceKey;
import org.hibernate.ogm.model.key.spi.RowKey;
import org.hibernate.ogm.model.spi.Association;
import org.hibernate.ogm.model.spi.AssociationSnapshot;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.model.spi.TupleOperation;
import org.hibernate.ogm.model.spi.TupleSnapshot;
import org.hibernate.ogm.type.impl.CharacterStringType;
import org.hibernate.ogm.type.impl.StringCalendarDateType;
import org.hibernate.ogm.type.spi.GridType;
import org.hibernate.ogm.util.impl.CollectionHelper;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.parboiled.Parboiled;
import org.parboiled.errors.ErrorUtils;
import org.parboiled.parserunners.RecoveringParseRunner;
import org.parboiled.support.ParsingResult;

public class MongoDBDialect
extends BaseGridDialect
implements QueryableGridDialect<MongoDBQueryDescriptor>,
BatchableGridDialect,
IdentityColumnAwareGridDialect,
MultigetGridDialect,
OptimisticLockingAwareGridDialect {
    public static final String ID_FIELDNAME = "_id";
    public static final String PROPERTY_SEPARATOR = ".";
    public static final String ROWS_FIELDNAME = "rows";
    public static final String TABLE_FIELDNAME = "table";
    public static final String ASSOCIATIONS_COLLECTION_PREFIX = "associations_";
    private static final Log log = LoggerFactory.getLogger();
    private static final List<String> ROWS_FIELDNAME_LIST = Collections.singletonList("rows");
    private final MongoDBDatastoreProvider provider;
    private final DB currentDB;

    public MongoDBDialect(MongoDBDatastoreProvider provider) {
        this.provider = provider;
        this.currentDB = this.provider.getDatabase();
    }

    public Tuple getTuple(EntityKey key, TupleContext tupleContext) {
        DBObject found = this.getObject(key, tupleContext);
        return this.createTuple(key, tupleContext, found);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Tuple> getTuples(EntityKey[] keys, TupleContext tupleContext) {
        if (keys.length == 0) {
            return Collections.emptyList();
        }
        Object[] searchObjects = new Object[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            searchObjects[i] = this.prepareIdObjectValue(keys[i].getColumnNames(), keys[i].getColumnValues());
        }
        try (DBCursor cursor = this.getObjects(keys[0].getMetadata(), searchObjects, tupleContext);){
            List<Tuple> list = this.tuplesResult(keys, searchObjects, tupleContext, cursor);
            return list;
        }
    }

    private List<Tuple> tuplesResult(EntityKey[] keys, Object[] searchObjects, TupleContext tupleContext, DBCursor cursor) {
        Tuple[] tuples = new Tuple[searchObjects.length];
        block0: for (DBObject dbObject : cursor) {
            for (int i = 0; i < searchObjects.length; ++i) {
                if (!dbObject.get(ID_FIELDNAME).equals(searchObjects[i])) continue;
                tuples[i] = this.createTuple(keys[i], tupleContext, dbObject);
                continue block0;
            }
        }
        return Arrays.asList(tuples);
    }

    private Tuple createTuple(EntityKey key, TupleContext tupleContext, DBObject found) {
        if (found != null) {
            return new Tuple((TupleSnapshot)new MongoDBTupleSnapshot(found, key.getMetadata(), MongoDBTupleSnapshot.SnapshotType.UPDATE));
        }
        if (this.isInTheQueue(key, tupleContext)) {
            return new Tuple((TupleSnapshot)new MongoDBTupleSnapshot((DBObject)this.prepareIdObject(key), key.getMetadata(), MongoDBTupleSnapshot.SnapshotType.INSERT));
        }
        return null;
    }

    private boolean isInTheQueue(EntityKey key, TupleContext tupleContext) {
        OperationsQueue queue = tupleContext.getOperationsQueue();
        return queue != null && queue.contains(key);
    }

    public Tuple createTuple(EntityKeyMetadata entityKeyMetadata, TupleContext tupleContext) {
        return new Tuple((TupleSnapshot)new MongoDBTupleSnapshot((DBObject)new BasicDBObject(), entityKeyMetadata, MongoDBTupleSnapshot.SnapshotType.INSERT));
    }

    public Tuple createTuple(EntityKey key, TupleContext tupleContext) {
        BasicDBObject toSave = this.prepareIdObject(key);
        return new Tuple((TupleSnapshot)new MongoDBTupleSnapshot((DBObject)toSave, key.getMetadata(), MongoDBTupleSnapshot.SnapshotType.INSERT));
    }

    private DBObject getEmbeddingEntity(AssociationKey key, AssociationContext associationContext) {
        DBObject embeddingEntityDocument;
        DBObject dBObject = embeddingEntityDocument = associationContext.getEntityTuple() != null ? ((MongoDBTupleSnapshot)associationContext.getEntityTuple().getSnapshot()).getDbObject() : null;
        if (embeddingEntityDocument != null) {
            return embeddingEntityDocument;
        }
        ReadPreference readPreference = this.getReadPreference(associationContext);
        DBCollection collection = this.getCollection(key.getEntityKey());
        BasicDBObject searchObject = this.prepareIdObject(key.getEntityKey());
        DBObject projection = this.getProjection(key, true);
        return collection.findOne((DBObject)searchObject, projection, readPreference);
    }

    private DBObject getObject(EntityKey key, TupleContext tupleContext) {
        ReadPreference readPreference = this.getReadPreference(tupleContext);
        DBCollection collection = this.getCollection(key);
        BasicDBObject searchObject = this.prepareIdObject(key);
        BasicDBObject projection = this.getProjection(tupleContext);
        return collection.findOne((DBObject)searchObject, (DBObject)projection, readPreference);
    }

    private DBCursor getObjects(EntityKeyMetadata entityKeyMetadata, Object[] searchObjects, TupleContext tupleContext) {
        ReadPreference readPreference = this.getReadPreference(tupleContext);
        DBCollection collection = this.getCollection(entityKeyMetadata);
        collection.setReadPreference(readPreference);
        BasicDBObject projection = this.getProjection(tupleContext);
        BasicDBObject query = new BasicDBObject();
        query.put(ID_FIELDNAME, (Object)new BasicDBObject("$in", (Object)searchObjects));
        return collection.find((DBObject)query, (DBObject)projection);
    }

    private BasicDBObject getProjection(TupleContext tupleContext) {
        return this.getProjection(tupleContext.getSelectableColumns());
    }

    private BasicDBObject getProjection(List<String> fieldNames) {
        BasicDBObject projection = new BasicDBObject(fieldNames.size());
        for (String column : fieldNames) {
            projection.put((Object)column, (Object)1);
        }
        return projection;
    }

    private BasicDBObject prepareIdObject(EntityKey key) {
        return this.prepareIdObject(key.getColumnNames(), key.getColumnValues());
    }

    private BasicDBObject prepareIdObject(IdSourceKey key) {
        return this.prepareIdObject(key.getColumnNames(), key.getColumnValues());
    }

    private BasicDBObject prepareIdObject(String[] columnNames, Object[] columnValues) {
        return new BasicDBObject(ID_FIELDNAME, this.prepareIdObjectValue(columnNames, columnValues));
    }

    private Object prepareIdObjectValue(String[] columnNames, Object[] columnValues) {
        if (columnNames.length == 1) {
            return columnValues[0];
        }
        BasicDBObject idObject = new BasicDBObject();
        for (int i = 0; i < columnNames.length; ++i) {
            String columnName = columnNames[i];
            Object columnValue = columnValues[i];
            if (columnName.contains(PROPERTY_SEPARATOR)) {
                int dotIndex = columnName.indexOf(PROPERTY_SEPARATOR);
                String shortColumnName = columnName.substring(dotIndex + 1);
                idObject.put(shortColumnName, columnValue);
                continue;
            }
            idObject.put(columnNames[i], columnValue);
        }
        return idObject;
    }

    private DBCollection getCollection(String table) {
        return this.currentDB.getCollection(table);
    }

    private DBCollection getCollection(EntityKey key) {
        return this.getCollection(key.getTable());
    }

    private DBCollection getCollection(EntityKeyMetadata entityKeyMetadata) {
        return this.getCollection(entityKeyMetadata.getTable());
    }

    private DBCollection getAssociationCollection(AssociationKey key, AssociationStorageStrategy storageStrategy) {
        if (storageStrategy == AssociationStorageStrategy.GLOBAL_COLLECTION) {
            return this.getCollection("Associations");
        }
        return this.getCollection(ASSOCIATIONS_COLLECTION_PREFIX + key.getTable());
    }

    private BasicDBObject getSubQuery(String operator, BasicDBObject query) {
        return query.get(operator) != null ? (BasicDBObject)query.get(operator) : new BasicDBObject();
    }

    private void addSubQuery(String operator, BasicDBObject query, String column, Object value) {
        BasicDBObject subQuery = this.getSubQuery(operator, query);
        query.append(operator, (Object)subQuery.append(column, value));
    }

    public void insertOrUpdateTuple(EntityKey key, Tuple tuple, TupleContext tupleContext) {
        BasicDBObject idObject = this.prepareIdObject(key);
        DBObject updater = this.objectForUpdate(tuple, (DBObject)idObject, tupleContext);
        WriteConcern writeConcern = this.getWriteConcern(tupleContext);
        try {
            this.getCollection(key).update((DBObject)idObject, updater, true, false, writeConcern);
        }
        catch (DuplicateKeyException dke) {
            throw new TupleAlreadyExistsException(key.getMetadata(), tuple, (Throwable)dke);
        }
    }

    public boolean updateTupleWithOptimisticLock(EntityKey entityKey, Tuple oldLockState, Tuple tuple, TupleContext tupleContext) {
        BasicDBObject idObject = this.prepareIdObject(entityKey);
        for (String versionColumn : oldLockState.getColumnNames()) {
            idObject.put((Object)versionColumn, oldLockState.get(versionColumn));
        }
        DBObject updater = this.objectForUpdate(tuple, (DBObject)idObject, tupleContext);
        DBObject doc = this.getCollection(entityKey).findAndModify((DBObject)idObject, updater);
        return doc != null;
    }

    public void insertTuple(EntityKeyMetadata entityKeyMetadata, Tuple tuple, TupleContext tupleContext) {
        WriteConcern writeConcern = this.getWriteConcern(tupleContext);
        DBObject objectWithId = this.insertDBObject(entityKeyMetadata, tuple, writeConcern);
        String idColumnName = entityKeyMetadata.getColumnNames()[0];
        tuple.put(idColumnName, objectWithId.get(ID_FIELDNAME));
    }

    private DBObject insertDBObject(EntityKeyMetadata entityKeyMetadata, Tuple tuple, WriteConcern writeConcern) {
        DBObject dbObject = this.objectForInsert(tuple, ((MongoDBTupleSnapshot)tuple.getSnapshot()).getDbObject());
        this.getCollection(entityKeyMetadata).insert(dbObject, writeConcern);
        return dbObject;
    }

    private DBObject objectForInsert(Tuple tuple, DBObject dbObject) {
        MongoDBTupleSnapshot snapshot = (MongoDBTupleSnapshot)tuple.getSnapshot();
        for (TupleOperation operation : tuple.getOperations()) {
            String column = operation.getColumn();
            if (!this.notInIdField(snapshot, column)) continue;
            switch (operation.getType()) {
                case PUT: {
                    MongoHelpers.setValue(dbObject, column, operation.getValue());
                    break;
                }
                case PUT_NULL: 
                case REMOVE: {
                    MongoHelpers.resetValue(dbObject, column);
                }
            }
        }
        return dbObject;
    }

    private DBObject objectForUpdate(Tuple tuple, DBObject idObject, TupleContext tupleContext) {
        MongoDBTupleSnapshot snapshot = (MongoDBTupleSnapshot)tuple.getSnapshot();
        EmbeddableStateFinder embeddableStateFinder = new EmbeddableStateFinder(tuple, tupleContext);
        HashSet<String> nullEmbeddables = new HashSet<String>();
        BasicDBObject updater = new BasicDBObject();
        for (TupleOperation operation : tuple.getOperations()) {
            String column = operation.getColumn();
            if (!this.notInIdField(snapshot, column)) continue;
            switch (operation.getType()) {
                case PUT: {
                    this.addSubQuery("$set", updater, column, operation.getValue());
                    break;
                }
                case PUT_NULL: 
                case REMOVE: {
                    String nullEmbeddable = embeddableStateFinder.getOuterMostNullEmbeddableIfAny(column);
                    if (nullEmbeddable != null) {
                        if (nullEmbeddables.contains(nullEmbeddable)) break;
                        this.addSubQuery("$unset", updater, nullEmbeddable, 1);
                        nullEmbeddables.add(nullEmbeddable);
                        break;
                    }
                    this.addSubQuery("$unset", updater, column, 1);
                }
            }
        }
        if (updater.size() == 0) {
            return idObject;
        }
        return updater;
    }

    private boolean notInIdField(MongoDBTupleSnapshot snapshot, String column) {
        return !column.equals(ID_FIELDNAME) && !column.endsWith("._id") && !snapshot.isKeyColumn(column);
    }

    public void removeTuple(EntityKey key, TupleContext tupleContext) {
        DBCollection collection = this.getCollection(key);
        BasicDBObject toDelete = this.prepareIdObject(key);
        WriteConcern writeConcern = this.getWriteConcern(tupleContext);
        collection.remove((DBObject)toDelete, writeConcern);
    }

    public boolean removeTupleWithOptimisticLock(EntityKey entityKey, Tuple oldLockState, TupleContext tupleContext) {
        BasicDBObject toDelete = this.prepareIdObject(entityKey);
        for (String versionColumn : oldLockState.getColumnNames()) {
            toDelete.put(versionColumn, oldLockState.get(versionColumn));
        }
        DBCollection collection = this.getCollection(entityKey);
        DBObject deleted = collection.findAndRemove((DBObject)toDelete);
        return deleted != null;
    }

    private DBObject findAssociation(AssociationKey key, AssociationContext associationContext, AssociationStorageStrategy storageStrategy) {
        ReadPreference readPreference = this.getReadPreference(associationContext);
        DBObject associationKeyObject = this.associationKeyToObject(key, storageStrategy);
        return this.getAssociationCollection(key, storageStrategy).findOne(associationKeyObject, this.getProjection(key, false), readPreference);
    }

    private DBObject getProjection(AssociationKey key, boolean embedded) {
        if (embedded) {
            return this.getProjection(Collections.singletonList(key.getMetadata().getCollectionRole()));
        }
        return this.getProjection(ROWS_FIELDNAME_LIST);
    }

    private boolean isInTheQueue(EntityKey key, AssociationContext associationContext) {
        OperationsQueue queue = associationContext.getOperationsQueue();
        return queue != null && queue.contains(key);
    }

    public Association getAssociation(AssociationKey key, AssociationContext associationContext) {
        AssociationStorageStrategy storageStrategy = this.getAssociationStorageStrategy(key, associationContext);
        if (this.isEmbeddedAssociation(key) && this.isInTheQueue(key.getEntityKey(), associationContext)) {
            BasicDBObject idObject = this.prepareIdObject(key.getEntityKey());
            return new Association((AssociationSnapshot)new MongoDBAssociationSnapshot((DBObject)idObject, key, storageStrategy));
        }
        this.executeBatch(associationContext.getOperationsQueue());
        if (storageStrategy == AssociationStorageStrategy.IN_ENTITY) {
            DBObject entity = this.getEmbeddingEntity(key, associationContext);
            if (entity != null && MongoHelpers.hasField(entity, key.getMetadata().getCollectionRole())) {
                return new Association((AssociationSnapshot)new MongoDBAssociationSnapshot(entity, key, storageStrategy));
            }
            return null;
        }
        DBObject result = this.findAssociation(key, associationContext, storageStrategy);
        if (result == null) {
            return null;
        }
        return new Association((AssociationSnapshot)new MongoDBAssociationSnapshot(result, key, storageStrategy));
    }

    private boolean isEmbeddedAssociation(AssociationKey key) {
        return AssociationKind.EMBEDDED_COLLECTION == key.getMetadata().getAssociationKind();
    }

    public Association createAssociation(AssociationKey key, AssociationContext associationContext) {
        AssociationStorageStrategy storageStrategy = this.getAssociationStorageStrategy(key, associationContext);
        DBObject document = storageStrategy == AssociationStorageStrategy.IN_ENTITY ? this.getEmbeddingEntity(key, associationContext) : this.associationKeyToObject(key, storageStrategy);
        return new Association((AssociationSnapshot)new MongoDBAssociationSnapshot(document, key, storageStrategy));
    }

    private Object getAssociationRows(Association association, AssociationKey key, AssociationContext associationContext) {
        boolean organizeByRowKey = DotPatternMapHelpers.organizeAssociationMapByRowKey((Association)association, (AssociationKey)key, (AssociationContext)associationContext);
        if (organizeByRowKey) {
            String rowKeyColumn = organizeByRowKey ? key.getMetadata().getRowKeyIndexColumnNames()[0] : null;
            BasicDBObject rows = new BasicDBObject();
            for (RowKey rowKey : association.getKeys()) {
                DBObject row = (DBObject)this.getAssociationRow(association.get(rowKey), key);
                String rowKeyValue = (String)row.removeField(rowKeyColumn);
                if (row.keySet().size() == 1) {
                    rows.put(rowKeyValue, row.toMap().values().iterator().next());
                    continue;
                }
                rows.put(rowKeyValue, (Object)row);
            }
            return rows;
        }
        ArrayList<Object> rows = new ArrayList<Object>();
        for (RowKey rowKey : association.getKeys()) {
            rows.add(this.getAssociationRow(association.get(rowKey), key));
        }
        return rows;
    }

    private Object getAssociationRow(Tuple row, AssociationKey associationKey) {
        String[] rowKeyColumnsToPersist = associationKey.getMetadata().getColumnsWithoutKeyColumns((Iterable)row.getColumnNames());
        if (rowKeyColumnsToPersist.length == 1) {
            return row.get(rowKeyColumnsToPersist[0]);
        }
        String prefix = DotPatternMapHelpers.getColumnSharedPrefixOfAssociatedEntityLink((AssociationKey)associationKey);
        BasicDBObject rowObject = new BasicDBObject(rowKeyColumnsToPersist.length);
        for (String column : rowKeyColumnsToPersist) {
            Object value = row.get(column);
            if (value == null) continue;
            String columnName = column.startsWith(prefix) ? column.substring(prefix.length()) : column;
            MongoHelpers.setValue((DBObject)rowObject, columnName, value);
        }
        return rowObject;
    }

    public void insertOrUpdateAssociation(AssociationKey key, Association association, AssociationContext associationContext) {
        String associationField;
        DBObject query;
        DBCollection collection;
        Object toStore;
        MongoDBAssociationSnapshot assocSnapshot = (MongoDBAssociationSnapshot)association.getSnapshot();
        AssociationStorageStrategy storageStrategy = this.getAssociationStorageStrategy(key, associationContext);
        WriteConcern writeConcern = this.getWriteConcern(associationContext);
        Object rows = this.getAssociationRows(association, key, associationContext);
        Object object = toStore = key.getMetadata().getAssociationType() == AssociationType.ONE_TO_ONE ? ((List)rows).get(0) : rows;
        if (storageStrategy == AssociationStorageStrategy.IN_ENTITY) {
            collection = this.getCollection(key.getEntityKey());
            query = this.prepareIdObject(key.getEntityKey());
            associationField = key.getMetadata().getCollectionRole();
            ((MongoDBTupleSnapshot)associationContext.getEntityTuple().getSnapshot()).getDbObject().put(key.getMetadata().getCollectionRole(), toStore);
        } else {
            collection = this.getAssociationCollection(key, storageStrategy);
            query = assocSnapshot.getQueryObject();
            associationField = ROWS_FIELDNAME;
        }
        BasicDBObject update = new BasicDBObject("$set", (Object)new BasicDBObject(associationField, toStore));
        collection.update(query, (DBObject)update, true, false, writeConcern);
    }

    public void removeAssociation(AssociationKey key, AssociationContext associationContext) {
        AssociationStorageStrategy storageStrategy = this.getAssociationStorageStrategy(key, associationContext);
        WriteConcern writeConcern = this.getWriteConcern(associationContext);
        if (storageStrategy == AssociationStorageStrategy.IN_ENTITY) {
            BasicDBObject entity = this.prepareIdObject(key.getEntityKey());
            if (entity != null) {
                BasicDBObject updater = new BasicDBObject();
                this.addSubQuery("$unset", updater, key.getMetadata().getCollectionRole(), 1);
                DBObject dbObject = this.getEmbeddingEntity(key, associationContext);
                if (dbObject != null) {
                    dbObject.removeField(key.getMetadata().getCollectionRole());
                    this.getCollection(key.getEntityKey()).update((DBObject)entity, (DBObject)updater, true, false, writeConcern);
                }
            }
        } else {
            DBCollection collection = this.getAssociationCollection(key, storageStrategy);
            DBObject query = this.associationKeyToObject(key, storageStrategy);
            int nAffected = collection.remove(query, writeConcern).getN();
            log.removedAssociation(nAffected);
        }
    }

    public Number nextValue(NextValueRequest request) {
        Object idFromDB;
        DBCollection currentCollection = this.getCollection(request.getKey().getTable());
        BasicDBObject query = this.prepareIdObject(request.getKey());
        String valueColumnName = request.getKey().getMetadata().getValueColumnName();
        BasicDBObject update = new BasicDBObject();
        Integer incrementObject = request.getIncrement();
        this.addSubQuery("$inc", update, valueColumnName, incrementObject);
        DBObject result = currentCollection.findAndModify((DBObject)query, null, null, false, (DBObject)update, false, true);
        Object object = idFromDB = result == null ? null : result.get(valueColumnName);
        if (idFromDB == null) {
            BasicDBObject updateForInitial = new BasicDBObject();
            this.addSubQuery("$inc", updateForInitial, valueColumnName, request.getInitialValue());
            currentCollection.findAndModify((DBObject)query, null, null, false, (DBObject)updateForInitial, false, true);
            idFromDB = request.getInitialValue();
        } else {
            idFromDB = result.get(valueColumnName);
        }
        if (idFromDB.getClass().equals(Integer.class) || idFromDB.getClass().equals(Long.class)) {
            Number id = (Number)idFromDB;
            return id;
        }
        throw new HibernateException("Cannot increment a non numeric field");
    }

    public boolean isStoredInEntityStructure(AssociationKeyMetadata associationKeyMetadata, AssociationTypeContext associationTypeContext) {
        return this.getAssociationStorageStrategy(associationKeyMetadata, associationTypeContext) == AssociationStorageStrategy.IN_ENTITY;
    }

    public GridType overrideType(Type type) {
        if (type == StandardBasicTypes.CALENDAR || type == StandardBasicTypes.CALENDAR_DATE) {
            return StringCalendarDateType.INSTANCE;
        }
        if (type == StandardBasicTypes.BYTE) {
            return ByteStringType.INSTANCE;
        }
        if (type == StandardBasicTypes.CHARACTER) {
            return CharacterStringType.INSTANCE;
        }
        if (type.getReturnedClass() == ObjectId.class) {
            return ObjectIdGridType.INSTANCE;
        }
        if (type instanceof StringAsObjectIdType) {
            return StringAsObjectIdGridType.INSTANCE;
        }
        return null;
    }

    public void forEachTuple(ModelConsumer consumer, EntityKeyMetadata ... entityKeyMetadatas) {
        DB db = this.provider.getDatabase();
        for (EntityKeyMetadata entityKeyMetadata : entityKeyMetadatas) {
            DBCollection collection = db.getCollection(entityKeyMetadata.getTable());
            for (DBObject dbObject : collection.find()) {
                consumer.consume(new Tuple((TupleSnapshot)new MongoDBTupleSnapshot(dbObject, entityKeyMetadata, MongoDBTupleSnapshot.SnapshotType.UPDATE)));
            }
        }
    }

    public ClosableIterator<Tuple> executeBackendQuery(BackendQuery<MongoDBQueryDescriptor> backendQuery, QueryParameters queryParameters) {
        MongoDBQueryDescriptor queryDescriptor = (MongoDBQueryDescriptor)backendQuery.getQuery();
        EntityKeyMetadata entityKeyMetadata = backendQuery.getSingleEntityKeyMetadataOrNull();
        String collectionName = this.getCollectionName(backendQuery, queryDescriptor, entityKeyMetadata);
        DBCollection collection = this.provider.getDatabase().getCollection(collectionName);
        switch (queryDescriptor.getOperation()) {
            case FIND: {
                return this.doFind(queryDescriptor, queryParameters, collection, entityKeyMetadata);
            }
            case AGGREGATE: {
                return this.doAggregate(queryDescriptor, queryParameters, collection, entityKeyMetadata);
            }
            case COUNT: {
                return this.doCount(queryDescriptor, collection);
            }
        }
        throw new IllegalArgumentException("Unexpected query operation: " + queryDescriptor);
    }

    public MongoDBQueryDescriptor parseNativeQuery(String nativeQuery) {
        NativeQueryParser parser = (NativeQueryParser)Parboiled.createParser(NativeQueryParser.class, (Object[])new Object[0]);
        ParsingResult parseResult = new RecoveringParseRunner(parser.Query()).run(nativeQuery);
        if (parseResult.hasErrors()) {
            throw new IllegalArgumentException("Unsupported native query: " + ErrorUtils.printParseErrors((List)parseResult.parseErrors));
        }
        return ((MongoDBQueryDescriptorBuilder)parseResult.resultValue).build();
    }

    public DuplicateInsertPreventionStrategy getDuplicateInsertPreventionStrategy(EntityKeyMetadata entityKeyMetadata) {
        return DuplicateInsertPreventionStrategy.NATIVE;
    }

    private ClosableIterator<Tuple> doAggregate(MongoDBQueryDescriptor query, QueryParameters queryParameters, DBCollection collection, EntityKeyMetadata entityKeyMetadata) {
        ArrayList<DBObject> pipeline = new ArrayList<DBObject>();
        pipeline.add(this.stage("$match", query.getCriteria()));
        pipeline.add(this.stage("$project", query.getProjection()));
        if (query.getUnwinds() != null && !query.getUnwinds().isEmpty()) {
            for (String field : query.getUnwinds()) {
                pipeline.add(this.stage("$unwind", "$" + field));
            }
        }
        if (query.getOrderBy() != null) {
            pipeline.add(this.stage("$sort", query.getOrderBy()));
        }
        if (queryParameters.getRowSelection().getFirstRow() != null) {
            pipeline.add(this.stage("$skip", queryParameters.getRowSelection().getFirstRow()));
        }
        if (queryParameters.getRowSelection().getMaxRows() != null) {
            pipeline.add(this.stage("$limit", queryParameters.getRowSelection().getMaxRows()));
        }
        AggregationOutput output = collection.aggregate(pipeline);
        return new MongoDBAggregationOutput(output, entityKeyMetadata);
    }

    private DBObject stage(String key, Object value) {
        BasicDBObject stage = new BasicDBObject();
        stage.put(key, value);
        return stage;
    }

    private ClosableIterator<Tuple> doFind(MongoDBQueryDescriptor query, QueryParameters queryParameters, DBCollection collection, EntityKeyMetadata entityKeyMetadata) {
        DBCursor cursor = collection.find(query.getCriteria(), query.getProjection());
        if (query.getOrderBy() != null) {
            cursor.sort(query.getOrderBy());
        }
        if (queryParameters.getRowSelection().getFirstRow() != null) {
            cursor.skip(queryParameters.getRowSelection().getFirstRow().intValue());
        }
        if (queryParameters.getRowSelection().getMaxRows() != null) {
            cursor.limit(queryParameters.getRowSelection().getMaxRows().intValue());
        }
        return new MongoDBResultsCursor(cursor, entityKeyMetadata);
    }

    private ClosableIterator<Tuple> doCount(MongoDBQueryDescriptor query, DBCollection collection) {
        long count = collection.count(query.getCriteria());
        MapTupleSnapshot snapshot = new MapTupleSnapshot(Collections.singletonMap("n", count));
        return CollectionHelper.newClosableIterator(Collections.singletonList(new Tuple((TupleSnapshot)snapshot)));
    }

    private String getCollectionName(BackendQuery<?> customQuery, MongoDBQueryDescriptor queryDescriptor, EntityKeyMetadata entityKeyMetadata) {
        if (queryDescriptor.getCollectionName() != null) {
            return queryDescriptor.getCollectionName();
        }
        if (entityKeyMetadata != null) {
            return entityKeyMetadata.getTable();
        }
        throw log.unableToDetermineCollectionName(customQuery.getQuery().toString());
    }

    private DBObject associationKeyToObject(AssociationKey key, AssociationStorageStrategy storageStrategy) {
        if (storageStrategy == AssociationStorageStrategy.IN_ENTITY) {
            throw new AssertionFailure(MongoHelpers.class.getName() + ".associationKeyToObject should not be called for associations embedded in entity documents");
        }
        Object[] columnValues = key.getColumnValues();
        BasicDBObject columns = new BasicDBObject(columnValues.length);
        String prefix = DocumentHelpers.getColumnSharedPrefix((String[])key.getColumnNames());
        prefix = prefix == null ? "" : prefix + PROPERTY_SEPARATOR;
        int i = 0;
        for (String name : key.getColumnNames()) {
            MongoHelpers.setValue((DBObject)columns, name.substring(prefix.length()), columnValues[i++]);
        }
        BasicDBObject idObject = new BasicDBObject(1);
        if (storageStrategy == AssociationStorageStrategy.GLOBAL_COLLECTION) {
            columns.put(TABLE_FIELDNAME, (Object)key.getTable());
        }
        idObject.put((Object)ID_FIELDNAME, (Object)columns);
        return idObject;
    }

    private AssociationStorageStrategy getAssociationStorageStrategy(AssociationKey key, AssociationContext associationContext) {
        return this.getAssociationStorageStrategy(key.getMetadata(), associationContext.getAssociationTypeContext());
    }

    private AssociationStorageStrategy getAssociationStorageStrategy(AssociationKeyMetadata keyMetadata, AssociationTypeContext associationTypeContext) {
        AssociationStorageType associationStorage = (AssociationStorageType)associationTypeContext.getOptionsContext().getUnique(AssociationStorageOption.class);
        AssociationDocumentStorageType associationDocumentStorageType = (AssociationDocumentStorageType)((Object)associationTypeContext.getOptionsContext().getUnique(AssociationDocumentStorageOption.class));
        return AssociationStorageStrategy.getInstance(keyMetadata, associationStorage, associationDocumentStorageType);
    }

    public void executeBatch(OperationsQueue queue) {
        if (!queue.isClosed()) {
            Operation operation = queue.poll();
            HashMap<DBCollection, BatchInsertionTask> inserts = new HashMap<DBCollection, BatchInsertionTask>();
            ArrayList<MongoDBTupleSnapshot> insertSnapshots = new ArrayList<MongoDBTupleSnapshot>();
            while (operation != null) {
                InsertOrUpdateTupleOperation update;
                if (operation instanceof InsertOrUpdateTupleOperation) {
                    update = (InsertOrUpdateTupleOperation)operation;
                    this.executeBatchUpdate(inserts, update);
                    MongoDBTupleSnapshot snapshot = (MongoDBTupleSnapshot)update.getTuple().getSnapshot();
                    if (snapshot.getSnapshotType() == MongoDBTupleSnapshot.SnapshotType.INSERT) {
                        insertSnapshots.add(snapshot);
                    }
                } else if (operation instanceof RemoveTupleOperation) {
                    RemoveTupleOperation tupleOp = (RemoveTupleOperation)operation;
                    this.executeBatchRemove(inserts, tupleOp);
                } else if (operation instanceof InsertOrUpdateAssociationOperation) {
                    update = (InsertOrUpdateAssociationOperation)operation;
                    this.executeBatchUpdateAssociation(inserts, (InsertOrUpdateAssociationOperation)update);
                } else if (operation instanceof RemoveAssociationOperation) {
                    RemoveAssociationOperation remove = (RemoveAssociationOperation)operation;
                    this.removeAssociation(remove.getAssociationKey(), remove.getContext());
                } else {
                    throw new UnsupportedOperationException("Operation not supported on MongoDB: " + operation.getClass().getName());
                }
                operation = queue.poll();
            }
            this.flushInserts(inserts);
            for (MongoDBTupleSnapshot insertSnapshot : insertSnapshots) {
                insertSnapshot.setSnapshotType(MongoDBTupleSnapshot.SnapshotType.UPDATE);
            }
            queue.close();
        }
    }

    private void executeBatchRemove(Map<DBCollection, BatchInsertionTask> inserts, RemoveTupleOperation tupleOperation) {
        EntityKey entityKey = tupleOperation.getEntityKey();
        DBCollection collection = this.getCollection(entityKey);
        BatchInsertionTask batchedInserts = inserts.get(collection);
        if (batchedInserts != null && batchedInserts.containsKey(entityKey)) {
            batchedInserts.remove(entityKey);
        } else {
            this.removeTuple(entityKey, tupleOperation.getTupleContext());
        }
    }

    private void executeBatchUpdate(Map<DBCollection, BatchInsertionTask> inserts, InsertOrUpdateTupleOperation tupleOperation) {
        EntityKey entityKey = tupleOperation.getEntityKey();
        Tuple tuple = tupleOperation.getTuple();
        MongoDBTupleSnapshot snapshot = (MongoDBTupleSnapshot)tupleOperation.getTuple().getSnapshot();
        WriteConcern writeConcern = this.getWriteConcern(tupleOperation.getTupleContext());
        if (MongoDBTupleSnapshot.SnapshotType.INSERT == snapshot.getSnapshotType()) {
            this.prepareForInsert(inserts, snapshot, entityKey, tuple, writeConcern);
        } else {
            this.insertOrUpdateTuple(entityKey, tuple, tupleOperation.getTupleContext());
        }
    }

    private void executeBatchUpdateAssociation(Map<DBCollection, BatchInsertionTask> inserts, InsertOrUpdateAssociationOperation updateOp) {
        AssociationKey associationKey = updateOp.getAssociationKey();
        if (this.isEmbeddedAssociation(associationKey)) {
            DBCollection collection = this.getCollection(associationKey.getEntityKey());
            BatchInsertionTask batchInserts = inserts.get(collection);
            if (batchInserts != null && batchInserts.containsKey(associationKey.getEntityKey())) {
                WriteConcern writeConcern = this.getWriteConcern(updateOp.getContext());
                BatchInsertionTask insertTask = this.getOrCreateBatchInsertionTask(inserts, associationKey.getEntityKey().getMetadata(), collection, writeConcern);
                DBObject documentForInsertion = insertTask.get(associationKey.getEntityKey());
                Object embeddedElements = this.getAssociationRows(updateOp.getAssociation(), updateOp.getAssociationKey(), updateOp.getContext());
                String collectionRole = associationKey.getMetadata().getCollectionRole();
                MongoHelpers.setValue(documentForInsertion, collectionRole, embeddedElements);
            } else {
                this.insertOrUpdateAssociation(updateOp.getAssociationKey(), updateOp.getAssociation(), updateOp.getContext());
            }
        } else {
            this.insertOrUpdateAssociation(updateOp.getAssociationKey(), updateOp.getAssociation(), updateOp.getContext());
        }
    }

    public ParameterMetadataBuilder getParameterMetadataBuilder() {
        return NoOpParameterMetadataBuilder.INSTANCE;
    }

    private void prepareForInsert(Map<DBCollection, BatchInsertionTask> inserts, MongoDBTupleSnapshot snapshot, EntityKey entityKey, Tuple tuple, WriteConcern writeConcern) {
        DBCollection collection = this.getCollection(entityKey);
        BatchInsertionTask batchInsertion = this.getOrCreateBatchInsertionTask(inserts, entityKey.getMetadata(), collection, writeConcern);
        DBObject document = this.getCurrentDocument(snapshot, batchInsertion, entityKey);
        DBObject newDocument = this.objectForInsert(tuple, document);
        inserts.get(collection).put(entityKey, newDocument);
    }

    private DBObject getCurrentDocument(MongoDBTupleSnapshot snapshot, BatchInsertionTask batchInsert, EntityKey entityKey) {
        DBObject fromBatchInsertion = batchInsert.get(entityKey);
        return fromBatchInsertion != null ? fromBatchInsertion : snapshot.getDbObject();
    }

    private BatchInsertionTask getOrCreateBatchInsertionTask(Map<DBCollection, BatchInsertionTask> inserts, EntityKeyMetadata entityKeyMetadata, DBCollection collection, WriteConcern writeConcern) {
        BatchInsertionTask insertsForCollection = inserts.get(collection);
        if (insertsForCollection == null) {
            insertsForCollection = new BatchInsertionTask(entityKeyMetadata, writeConcern);
            inserts.put(collection, insertsForCollection);
        }
        return insertsForCollection;
    }

    private void flushInserts(Map<DBCollection, BatchInsertionTask> inserts) {
        for (Map.Entry<DBCollection, BatchInsertionTask> entry : inserts.entrySet()) {
            DBCollection collection = entry.getKey();
            if (entry.getValue().isEmpty()) continue;
            try {
                collection.insert(entry.getValue().getAll(), entry.getValue().getWriteConcern());
            }
            catch (DuplicateKeyException dke) {
                throw new TupleAlreadyExistsException(entry.getValue().getEntityKeyMetadata(), null, (Throwable)dke);
            }
        }
        inserts.clear();
    }

    private WriteConcern getWriteConcern(TupleContext tupleContext) {
        return (WriteConcern)tupleContext.getOptionsContext().getUnique(WriteConcernOption.class);
    }

    private WriteConcern getWriteConcern(AssociationContext associationContext) {
        return (WriteConcern)associationContext.getAssociationTypeContext().getOptionsContext().getUnique(WriteConcernOption.class);
    }

    private ReadPreference getReadPreference(TupleContext tupleContext) {
        return (ReadPreference)tupleContext.getOptionsContext().getUnique(ReadPreferenceOption.class);
    }

    private ReadPreference getReadPreference(AssociationContext associationContext) {
        return (ReadPreference)associationContext.getAssociationTypeContext().getOptionsContext().getUnique(ReadPreferenceOption.class);
    }

    private static class BatchInsertionTask {
        private final EntityKeyMetadata entityKeyMetadata;
        private final Map<EntityKey, DBObject> inserts;
        private final WriteConcern writeConcern;

        public BatchInsertionTask(EntityKeyMetadata entityKeyMetadata, WriteConcern writeConcern) {
            this.entityKeyMetadata = entityKeyMetadata;
            this.inserts = new HashMap<EntityKey, DBObject>();
            this.writeConcern = writeConcern;
        }

        public EntityKeyMetadata getEntityKeyMetadata() {
            return this.entityKeyMetadata;
        }

        public List<DBObject> getAll() {
            return new ArrayList<DBObject>(this.inserts.values());
        }

        public DBObject get(EntityKey entityKey) {
            return this.inserts.get(entityKey);
        }

        public boolean containsKey(EntityKey entityKey) {
            return this.inserts.containsKey(entityKey);
        }

        public DBObject remove(EntityKey entityKey) {
            return this.inserts.remove(entityKey);
        }

        public void put(EntityKey entityKey, DBObject object) {
            this.inserts.put(entityKey, object);
        }

        public WriteConcern getWriteConcern() {
            return this.writeConcern;
        }

        public boolean isEmpty() {
            return this.inserts.isEmpty();
        }
    }

    private static class MongoDBResultsCursor
    implements ClosableIterator<Tuple> {
        private final DBCursor cursor;
        private final EntityKeyMetadata metadata;

        public MongoDBResultsCursor(DBCursor cursor, EntityKeyMetadata metadata) {
            this.cursor = cursor;
            this.metadata = metadata;
        }

        public boolean hasNext() {
            return this.cursor.hasNext();
        }

        public Tuple next() {
            DBObject dbObject = this.cursor.next();
            return new Tuple((TupleSnapshot)new MongoDBTupleSnapshot(dbObject, this.metadata, MongoDBTupleSnapshot.SnapshotType.UPDATE));
        }

        public void remove() {
            this.cursor.remove();
        }

        public void close() {
            this.cursor.close();
        }
    }

    private static class MongoDBAggregationOutput
    implements ClosableIterator<Tuple> {
        private final Iterator<DBObject> results;
        private final EntityKeyMetadata metadata;

        public MongoDBAggregationOutput(AggregationOutput output, EntityKeyMetadata metadata) {
            this.results = output.results().iterator();
            this.metadata = metadata;
        }

        public boolean hasNext() {
            return this.results.hasNext();
        }

        public Tuple next() {
            DBObject dbObject = this.results.next();
            return new Tuple((TupleSnapshot)new MongoDBTupleSnapshot(dbObject, this.metadata, MongoDBTupleSnapshot.SnapshotType.UPDATE));
        }

        public void remove() {
            this.results.remove();
        }

        public void close() {
        }
    }
}

