/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb.dialect.impl;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.hibernate.ogm.datastore.document.association.spi.AssociationRowFactory;
import org.hibernate.ogm.datastore.document.association.spi.AssociationRows;
import org.hibernate.ogm.datastore.mongodb.dialect.impl.AssociationStorageStrategy;
import org.hibernate.ogm.datastore.mongodb.dialect.impl.MongoDBAssociationRowFactory;
import org.hibernate.ogm.datastore.mongodb.dialect.impl.MongoHelpers;
import org.hibernate.ogm.model.key.spi.AssociationKey;

public class MongoDBAssociationSnapshot
extends AssociationRows {
    private final DBObject dbObject;

    public MongoDBAssociationSnapshot(DBObject document, AssociationKey associationKey, AssociationStorageStrategy storageStrategy) {
        super(associationKey, MongoDBAssociationSnapshot.getRows(document, associationKey, storageStrategy), (AssociationRowFactory)MongoDBAssociationRowFactory.INSTANCE);
        this.dbObject = document;
    }

    public DBObject getQueryObject() {
        BasicDBObject query = new BasicDBObject();
        query.put("_id", this.dbObject.get("_id"));
        return query;
    }

    private static Collection<?> getRows(DBObject document, AssociationKey associationKey, AssociationStorageStrategy storageStrategy) {
        Object oneToOneValue;
        Collection<Object> rows = storageStrategy == AssociationStorageStrategy.IN_ENTITY ? (associationKey.getMetadata().isOneToOne() ? ((oneToOneValue = MongoHelpers.getValueOrNull(document, associationKey.getMetadata().getCollectionRole(), Object.class)) != null ? Collections.singletonList(oneToOneValue) : Collections.emptyList()) : MongoHelpers.getValueOrNull(document, associationKey.getMetadata().getCollectionRole(), Collection.class)) : (List)document.get("rows");
        return rows != null ? rows : Collections.emptyList();
    }

    public DBObject getDBObject() {
        return this.dbObject;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MongoDBAssociationSnapshot(");
        sb.append(this.size());
        sb.append(") RowKey entries).");
        return sb.toString();
    }
}

