/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb.query.parsing.impl;

import java.util.List;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.hql.ast.origin.hql.resolve.path.PropertyPath;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.hibernate.hql.ast.spi.PropertyHelper;
import org.hibernate.ogm.persister.impl.OgmEntityPersister;
import org.hibernate.type.AbstractStandardBasicType;
import org.hibernate.type.ComponentType;
import org.hibernate.type.Type;

public class MongoDBPropertyHelper
implements PropertyHelper {
    private final SessionFactoryImplementor sessionFactory;
    private final EntityNamesResolver entityNames;

    public MongoDBPropertyHelper(SessionFactoryImplementor sessionFactory, EntityNamesResolver entityNames) {
        this.sessionFactory = sessionFactory;
        this.entityNames = entityNames;
    }

    public Object convertToPropertyType(String entityType, List<String> propertyPath, String value) {
        Type propertyType = this.getPropertyType(entityType, propertyPath);
        if (propertyType.isEntityType()) {
            throw new UnsupportedOperationException("Queries on associated entities are not supported yet.");
        }
        if (propertyType instanceof AbstractStandardBasicType) {
            return ((AbstractStandardBasicType)propertyType).fromString(value);
        }
        return value;
    }

    private Type getPropertyType(String entityType, List<String> propertyPath) {
        OgmEntityPersister persister = this.getPersister(entityType);
        String propertyName = propertyPath.get(0);
        Type propertyType = persister.getPropertyType(propertyName);
        if (propertyPath.size() == 1) {
            return propertyType;
        }
        if (propertyType.isComponentType()) {
            return this.embeddedPropertyType(propertyPath, (ComponentType)propertyType);
        }
        throw new UnsupportedOperationException("Queries on associated entities are not supported yet.");
    }

    private Type embeddedPropertyType(List<String> propertyPath, ComponentType propertyType) {
        ComponentType subType = propertyType;
        for (int i = 1; i < propertyPath.size(); ++i) {
            ComponentType componentType = subType;
            String name = propertyPath.get(i);
            int propertyIndex = componentType.getPropertyIndex(name);
            subType = componentType.getSubtypes()[propertyIndex];
            if (!subType.isAnyType() && !subType.isAssociationType() && !subType.isEntityType()) continue;
            throw new UnsupportedOperationException("Queries on associated entities are not supported yet.");
        }
        return subType;
    }

    public String getColumnName(String entityType, String propertyName) {
        return this.getColumnName(this.getPersister(entityType), propertyName);
    }

    public String getColumnName(Class<?> entityType, String propertyName) {
        return this.getColumnName((OgmEntityPersister)this.sessionFactory.getEntityPersister(entityType.getName()), propertyName);
    }

    public String getColumnName(OgmEntityPersister persister, String propertyName) {
        String columnName = propertyName;
        if (columnName.equals(persister.getIdentifierPropertyName())) {
            columnName = "_id";
        } else {
            String[] columnNames = persister.getPropertyColumnNames(columnName);
            columnName = columnNames[0];
        }
        return columnName;
    }

    private OgmEntityPersister getPersister(String entityType) {
        Class targetedType = this.entityNames.getClassFromName(entityType);
        if (targetedType == null) {
            throw new IllegalStateException("Unknown entity name " + entityType);
        }
        return (OgmEntityPersister)this.sessionFactory.getEntityPersister(targetedType.getName());
    }

    public boolean isEmbedddedProperty(String targetTypeName, PropertyPath propertyPath) {
        List namesWithoutAlias = propertyPath.getNodeNamesWithoutAlias();
        OgmEntityPersister persister = this.getPersister(targetTypeName);
        Type propertyType = persister.getPropertyType((String)namesWithoutAlias.get(0));
        return propertyType.isComponentType() && !propertyType.isAssociationType();
    }
}

