/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb.impl;

import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import org.hibernate.ogm.datastore.spi.Tuple;
import org.hibernate.ogm.datastore.spi.TupleSnapshot;
import org.hibernate.ogm.dialect.mongodb.MongoDBTupleSnapshot;
import org.hibernate.ogm.grid.EntityKeyMetadata;
import org.hibernate.ogm.grid.RowKey;

public class MongoDBResultTupleIterable
implements Iterable<Tuple>,
Closeable {
    private final DBCursor cursor;
    private final EntityKeyMetadata keyMetaData;

    public MongoDBResultTupleIterable(DBCursor cursor, EntityKeyMetadata keyMetaData) {
        this.cursor = cursor;
        this.keyMetaData = keyMetaData;
    }

    @Override
    public void close() throws IOException {
        this.cursor.close();
    }

    @Override
    public Iterator<Tuple> iterator() {
        return new MongoDBResultsCursorIterator(this.cursor, this.keyMetaData);
    }

    private static class MongoDBResultsCursorIterator
    implements Iterator<Tuple> {
        private final DBCursor cursor;
        private final EntityKeyMetadata keyMetaData;

        public MongoDBResultsCursorIterator(DBCursor cursor, EntityKeyMetadata keyMetaData) {
            this.cursor = cursor;
            this.keyMetaData = keyMetaData;
        }

        @Override
        public boolean hasNext() {
            return this.cursor.hasNext();
        }

        @Override
        public Tuple next() {
            DBObject dbObject = this.cursor.next();
            RowKey rowKey = new RowKey(this.keyMetaData.getTable(), this.keyMetaData.getColumnNames(), new Object[]{dbObject.get("_id")});
            return new Tuple((TupleSnapshot)new MongoDBTupleSnapshot(dbObject, rowKey));
        }

        @Override
        public void remove() {
            this.cursor.remove();
        }
    }
}

