
package org.hibernate.ogm.logging.mongodb.impl;

import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.util.Arrays;
import javax.annotation.Generated;
import com.mongodb.MongoException;
import org.hibernate.hql.internal.ast.QuerySyntaxException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;


/**
 * Warning this class consists of generated code.
 * 
 */
@Generated(value = "org.jboss.logging.processor.model.MessageLoggerImplementor", date = "2013-10-25T17:31:49+0100")
public class Log_$logger
    extends DelegatingBasicLogger
    implements Serializable, org.hibernate.ogm.logging.mongodb.impl.Log, org.hibernate.ogm.util.impl.Log, BasicLogger
{

    private final static long serialVersionUID = 1L;
    private final static String projectCode = "OGM";
    private final static String FQCN = Log_$logger.class.getName();
    private final static String querySyntaxException = "Syntax error in query: [%1$s]";
    private final static String unknownDatastoreManagerType = "DatastoreManager property is of unknown type %1$s";
    private final static String unexpectedDatastoreProvider = "Expected DatastoreProvider %2$s but found %1$s";
    private final static String unknownAssociationStorageStrategy = "Unknown association storage strategy: [%s]. Supported values in enum %s";
    private final static String persistenceXmlNotFoundInClassPath = "Could not find any META-INF/persistence.xml file in the classpath. Unable to build Persistence Unit %1$s";
    private final static String givenImplementationClassIsOfWrongType = "Given class %2$s is no implementation/sub-type of %1$s.";
    private final static String disconnectingFromMongo = "Closing connection to MongoDB";
    private final static String cannotCreateNewProxyInstance = "Unable to create new proxy instance";
    private final static String useGridDialect = "Grid Dialect: %1$s";
    private final static String requireMetadatas = "The result of a native query in MongoDB must be mapped by an entity";
    private final static String useDatastoreProvider = "NoSQL Datastore provider: %1$s";
    private final static String unableToInitializeInfinispan = "Unable to find or initialize Infinispan CacheManager";
    private final static String noDatastoreConfigured = "hibernate.ogm.datastore.provider has not been defined and no DatastoreManager could be guessed";
    private final static String unableToConvertStringToDiscriminator = "Could not convert string to discriminator object";
    private final static String cannotConvertAnnotation = "Annotation cannot be converted using %1$s";
    private final static String creatingDatabase = "Mongo database named [%s] is not defined. Creating it!";
    private final static String unableToLoadContext = "Unable to load %1$s method from %2$s ";
    private final static String mongoDBTimeOutIllegalValue = "The value set for the configuration propertyhibernate.ogm.mongodb.connection_timeout must be a number greater than 0. Found '[%s]'.";
    private final static String mongoPortIllegalValue = "The value set for the configuration property 'hibernate.ogm.mongodb.port' must be a number between 1 and 65535. Found '[%s]'.";
    private final static String unableToMarkTransactionForRollback = "Unable to mark JTA transaction for rollback";
    private final static String interruptedBatchIndexing = "Batch indexing was interrupted";
    private final static String unableToSetWriteConcern = "'%s' cannot be set as an available value for hibernate.ogm.mongodb.writeconcern you must choose between [ACKNOWLEDGED, ERRORS_IGNORED, FSYNC_IGNORED, UNACKNOWLEDGED, FSYNCED, JOURNALED, REPLICA_ACKNOWLEDGED,NONE, NORMAL, SAFE, MAJORITY, FSYNC_SAFE, JOURNAL_SAFE, REPLICAS_SAFE]";
    private final static String getWrongDatastoreConfigurationTypeException = "The current datastore can not be configured via configuration type %1$s.";
    private final static String jtaCouldNotDetermineStatus = "Could not determine transaction status";
    private final static String useWriteConcern = "The configuration property 'hibernate.ogm.mongodb.writeconcern' is set to %s";
    private final static String cannotCreateEntityContextProxy = "Unable to create entity context proxy for type %1$s";
    private final static String unableToInitializeMongoDB = "Unable to find or initialize a connection to the MongoDB server";
    private final static String unableToConnectToDatastore = "Unable to connect to MongoDB instance %1$s:%2$d";
    private final static String jtaCommitFailed = "JTA transaction commit failed";
    private final static String jtaTransactionBeginFailed = "JTA transaction begin failed";
    private final static String unableToDropDatabase = "The database named [%s] cannot be dropped";
    private final static String dialectClassCannotBeFound = "GridDialect class [%1$s] cannot be found in classpath";
    private final static String notADatastoreManager = "%1$s is not a subclass of DatastoreManager. Update hibernate.ogm.datastore.provider";
    private final static String mongoOnUnknownHost = "Could not resolve MongoDB hostname [%s]";
    private final static String connectingToMongoDatabase = "Connecting to Mongo database named [%s].";
    private final static String gridDialectPropertyOfUnknownType = "GridDialect property is of unknown type %1$s";
    private final static String illegalDiscrimantorType = "Illegal discriminator type: '%1$s'";
    private final static String unableToInstantiateQueryParserService = "Cannot instantiate query parser service %s.";
    private final static String version = "Hibernate OGM %1$s";
    private final static String mongoDbNameMissing = "The configuration property 'hibernate.ogm.mongodb.database' was not set. Can't connect to MongoDB.";
    private final static String doesNotImplementGridDialect = "%1$s property does not implement GridDialect interface";
    private final static String mappingSubtypeNotInterface = "Unable to support mapping subtypes that are not interfaces: %1$s";
    private final static String removedAssociation = "Removed [%d] associations";
    private final static String jtaRollbackFailed = "JTA transaction rollback failed";
    private final static String unableToSetTimeout = "Unable to set transaction timeout to '%1$s'";
    private final static String usingDefaultTransactionFactory = "Use default transaction factory (use a TransactionManager exclusively to pilot the transaction)";
    private final static String cannotInstantiateGridDialect = "Cannot instantiate GridDialect class [%1$s]";
    private final static String cannotCreatePropertyContextProxy = "Unable to create property context proxy for type %1$s";
    private final static String connectingToMongo = "Connecting to MongoDB at %1$s:%2$d with a timeout set at %3$d millisecond(s)";
    private final static String createdQuery = "Created query object '%2$s' from HQL/JP-QL query '%1$s'.";
    private final static String gridDialectHasNoProperConstrutor = "%1$s has no constructor accepting DatasourceProvider";
    private final static String getPropertyDoesNotExistException = "The given propery %1$s#%2$s with element type %3$s does not exist.";
    private final static String cannotCreateGlobalContextProxy = "Unable to create global context proxy for type %1$s";
    private final static String getUnsupportedElementTypeException = "The given element type %1$s is neither FIELD nor METHOD.";
    private final static String authenticationFailed = "MongoDB authentication failed with username [%s]";
    private final static String datastoreClassCannotBeFound = "DatastoreManager class [%1$s] cannot be found in classpath try with: %2$s";
    private final static String unsupportedIndexerConfigurationOption = "OgmMassIndexer doesn't support the configuration option '%s'. Its setting will be ignored.";
    private final static String unableToInstantiateDatastoreManager = "Cannot instantiate DatastoreManager %1$s";

    public Log_$logger(final Logger log) {
        super(log);
    }

    public final org.hibernate.HibernateException querySyntaxException(final QuerySyntaxException arg0, final String arg1) {
        org.hibernate.HibernateException result = new org.hibernate.HibernateException(String.format(((projectCode +"000024: ")+ querySyntaxException$str()), arg1), arg0);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String querySyntaxException$str() {
        return querySyntaxException;
    }

    public final org.hibernate.HibernateException unknownDatastoreManagerType(final String arg0) {
        org.hibernate.HibernateException result = new org.hibernate.HibernateException(String.format(((projectCode +"000007: ")+ unknownDatastoreManagerType$str()), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownDatastoreManagerType$str() {
        return unknownDatastoreManagerType;
    }

    public final org.hibernate.HibernateException unexpectedDatastoreProvider(final Class arg0, final Class arg1) {
        org.hibernate.HibernateException result = new org.hibernate.HibernateException(String.format(((projectCode +"000015: ")+ unexpectedDatastoreProvider$str()), arg0, arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unexpectedDatastoreProvider$str() {
        return unexpectedDatastoreProvider;
    }

    public final org.hibernate.HibernateException unknownAssociationStorageStrategy(final String databaseName, final Class enumType) {
        org.hibernate.HibernateException result = new org.hibernate.HibernateException(String.format(((projectCode +"001212: ")+ unknownAssociationStorageStrategy$str()), databaseName, enumType));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownAssociationStorageStrategy$str() {
        return unknownAssociationStorageStrategy;
    }

    public final void persistenceXmlNotFoundInClassPath(final String arg0) {
        super.log.logf(FQCN, (Logger.Level.WARN), null, ((projectCode +"000002: ")+ persistenceXmlNotFoundInClassPath$str()), arg0);
    }

    protected String persistenceXmlNotFoundInClassPath$str() {
        return persistenceXmlNotFoundInClassPath;
    }

    public final org.hibernate.HibernateException givenImplementationClassIsOfWrongType(final String arg0, final String arg1) {
        org.hibernate.HibernateException result = new org.hibernate.HibernateException(String.format(((projectCode +"000029: ")+ givenImplementationClassIsOfWrongType$str()), arg0, arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String givenImplementationClassIsOfWrongType$str() {
        return givenImplementationClassIsOfWrongType;
    }

    public final void disconnectingFromMongo() {
        super.log.logf(FQCN, (Logger.Level.INFO), null, ((projectCode +"001202: ")+ disconnectingFromMongo$str()));
    }

    protected String disconnectingFromMongo$str() {
        return disconnectingFromMongo;
    }

    public final org.hibernate.HibernateException cannotCreateNewProxyInstance(final Exception arg0) {
        org.hibernate.HibernateException result = new org.hibernate.HibernateException(String.format(((projectCode +"000033: ")+ cannotCreateNewProxyInstance$str())), arg0);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotCreateNewProxyInstance$str() {
        return cannotCreateNewProxyInstance;
    }

    public final void useGridDialect(final String arg0) {
        super.log.logf(FQCN, (Logger.Level.INFO), null, ((projectCode +"000017: ")+ useGridDialect$str()), arg0);
    }

    protected String useGridDialect$str() {
        return useGridDialect;
    }

    public final org.hibernate.HibernateException requireMetadatas() {
        org.hibernate.HibernateException result = new org.hibernate.HibernateException(String.format(((projectCode +"001217: ")+ requireMetadatas$str())));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String requireMetadatas$str() {
        return requireMetadatas;
    }

    public final void useDatastoreProvider(final String arg0) {
        super.log.logf(FQCN, (Logger.Level.INFO), null, ((projectCode +"000016: ")+ useDatastoreProvider$str()), arg0);
    }

    protected String useDatastoreProvider$str() {
        return useDatastoreProvider;
    }

    public final org.hibernate.HibernateException unableToInitializeInfinispan(final RuntimeException arg0) {
        org.hibernate.HibernateException result = new org.hibernate.HibernateException(String.format(((projectCode +"000004: ")+ unableToInitializeInfinispan$str())), arg0);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToInitializeInfinispan$str() {
        return unableToInitializeInfinispan;
    }

    public final org.hibernate.HibernateException noDatastoreConfigured() {
        org.hibernate.HibernateException result = new org.hibernate.HibernateException(String.format(((projectCode +"000009: ")+ noDatastoreConfigured$str())));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noDatastoreConfigured$str() {
        return noDatastoreConfigured;
    }

    public final org.hibernate.HibernateException unableToConvertStringToDiscriminator(final Exception arg0) {
        org.hibernate.HibernateException result = new org.hibernate.HibernateException(String.format(((projectCode +"000027: ")+ unableToConvertStringToDiscriminator$str())), arg0);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToConvertStringToDiscriminator$str() {
        return unableToConvertStringToDiscriminator;
    }

    public final org.hibernate.HibernateException cannotConvertAnnotation(final Class arg0, final Exception arg1) {
        org.hibernate.HibernateException result = new org.hibernate.HibernateException(String.format(((projectCode +"000034: ")+ cannotConvertAnnotation$str()), arg0), arg1);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotConvertAnnotation$str() {
        return cannotConvertAnnotation;
    }

    public final void creatingDatabase(final String dbName) {
        super.log.logf(FQCN, (Logger.Level.INFO), null, ((projectCode +"001206: ")+ creatingDatabase$str()), dbName);
    }

    protected String creatingDatabase$str() {
        return creatingDatabase;
    }

    public final org.hibernate.HibernateException unableToLoadContext(final String arg0, final Class arg1, final Exception arg2) {
        org.hibernate.HibernateException result = new org.hibernate.HibernateException(String.format(((projectCode +"000036: ")+ unableToLoadContext$str()), arg0, arg1), arg2);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToLoadContext$str() {
        return unableToLoadContext;
    }

    public final org.hibernate.HibernateException mongoDBTimeOutIllegalValue(final String value) {
        org.hibernate.HibernateException result = new org.hibernate.HibernateException(String.format(((projectCode +"001215: ")+ mongoDBTimeOutIllegalValue$str()), value));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mongoDBTimeOutIllegalValue$str() {
        return mongoDBTimeOutIllegalValue;
    }

    public final org.hibernate.HibernateException mongoPortIllegalValue(final String value) {
        org.hibernate.HibernateException result = new org.hibernate.HibernateException(String.format(((projectCode +"001204: ")+ mongoPortIllegalValue$str()), value));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mongoPortIllegalValue$str() {
        return mongoPortIllegalValue;
    }

    public final org.hibernate.TransactionException unableToMarkTransactionForRollback(final Exception arg0) {
        org.hibernate.TransactionException result = new org.hibernate.TransactionException(String.format(((projectCode +"000021: ")+ unableToMarkTransactionForRollback$str())), arg0);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToMarkTransactionForRollback$str() {
        return unableToMarkTransactionForRollback;
    }

    public final void interruptedBatchIndexing() {
        super.log.logf(FQCN, (Logger.Level.ERROR), null, ((projectCode +"000025: ")+ interruptedBatchIndexing$str()));
    }

    protected String interruptedBatchIndexing$str() {
        return interruptedBatchIndexing;
    }

    public final org.hibernate.HibernateException unableToSetWriteConcern(final String value) {
        org.hibernate.HibernateException result = new org.hibernate.HibernateException(String.format(((projectCode +"001216: ")+ unableToSetWriteConcern$str()), value));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToSetWriteConcern$str() {
        return unableToSetWriteConcern;
    }

    public final org.hibernate.HibernateException getWrongDatastoreConfigurationTypeException(final String arg0) {
        org.hibernate.HibernateException result = new org.hibernate.HibernateException(String.format(((projectCode +"000040: ")+ getWrongDatastoreConfigurationTypeException$str()), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getWrongDatastoreConfigurationTypeException$str() {
        return getWrongDatastoreConfigurationTypeException;
    }

    public final org.hibernate.TransactionException jtaCouldNotDetermineStatus(final javax.transaction.SystemException arg0) {
        org.hibernate.TransactionException result = new org.hibernate.TransactionException(String.format(((projectCode +"000022: ")+ jtaCouldNotDetermineStatus$str())), arg0);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String jtaCouldNotDetermineStatus$str() {
        return jtaCouldNotDetermineStatus;
    }

    public final void useWriteConcern(final String writeConcern) {
        super.log.logf(FQCN, (Logger.Level.INFO), null, ((projectCode +"001211: ")+ useWriteConcern$str()), writeConcern);
    }

    protected String useWriteConcern$str() {
        return useWriteConcern;
    }

    public final org.hibernate.HibernateException cannotCreateEntityContextProxy(final Class arg0, final Exception arg1) {
        org.hibernate.HibernateException result = new org.hibernate.HibernateException(String.format(((projectCode +"000038: ")+ cannotCreateEntityContextProxy$str()), arg0), arg1);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotCreateEntityContextProxy$str() {
        return cannotCreateEntityContextProxy;
    }

    public final org.hibernate.HibernateException unableToInitializeMongoDB(final RuntimeException e) {
        org.hibernate.HibernateException result = new org.hibernate.HibernateException(String.format(((projectCode +"001203: ")+ unableToInitializeMongoDB$str())), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToInitializeMongoDB$str() {
        return unableToInitializeMongoDB;
    }

    public final org.hibernate.HibernateException unableToConnectToDatastore(final String host, final int port, final Exception e) {
        org.hibernate.HibernateException result = new org.hibernate.HibernateException(String.format(((projectCode +"001214: ")+ unableToConnectToDatastore$str()), host, port), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToConnectToDatastore$str() {
        return unableToConnectToDatastore;
    }

    public final org.hibernate.TransactionException jtaCommitFailed(final Exception arg0) {
        org.hibernate.TransactionException result = new org.hibernate.TransactionException(String.format(((projectCode +"000019: ")+ jtaCommitFailed$str())), arg0);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String jtaCommitFailed$str() {
        return jtaCommitFailed;
    }

    public final org.hibernate.TransactionException jtaTransactionBeginFailed(final Exception arg0) {
        org.hibernate.TransactionException result = new org.hibernate.TransactionException(String.format(((projectCode +"000018: ")+ jtaTransactionBeginFailed$str())), arg0);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String jtaTransactionBeginFailed$str() {
        return jtaTransactionBeginFailed;
    }

    public final org.hibernate.HibernateException unableToDropDatabase(final MongoException e, final String databaseName) {
        org.hibernate.HibernateException result = new org.hibernate.HibernateException(String.format(((projectCode +"001209: ")+ unableToDropDatabase$str()), databaseName), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToDropDatabase$str() {
        return unableToDropDatabase;
    }

    public final org.hibernate.HibernateException dialectClassCannotBeFound(final String arg0) {
        org.hibernate.HibernateException result = new org.hibernate.HibernateException(String.format(((projectCode +"000010: ")+ dialectClassCannotBeFound$str()), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String dialectClassCannotBeFound$str() {
        return dialectClassCannotBeFound;
    }

    public final org.hibernate.HibernateException notADatastoreManager(final String arg0) {
        org.hibernate.HibernateException result = new org.hibernate.HibernateException(String.format(((projectCode +"000005: ")+ notADatastoreManager$str()), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String notADatastoreManager$str() {
        return notADatastoreManager;
    }

    public final org.hibernate.HibernateException mongoOnUnknownHost(final String hostname) {
        org.hibernate.HibernateException result = new org.hibernate.HibernateException(String.format(((projectCode +"001205: ")+ mongoOnUnknownHost$str()), hostname));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mongoOnUnknownHost$str() {
        return mongoOnUnknownHost;
    }

    public final void connectingToMongoDatabase(final String dbName) {
        super.log.logf(FQCN, (Logger.Level.INFO), null, ((projectCode +"001207: ")+ connectingToMongoDatabase$str()), dbName);
    }

    protected String connectingToMongoDatabase$str() {
        return connectingToMongoDatabase;
    }

    public final org.hibernate.HibernateException gridDialectPropertyOfUnknownType(final Class arg0) {
        org.hibernate.HibernateException result = new org.hibernate.HibernateException(String.format(((projectCode +"000012: ")+ gridDialectPropertyOfUnknownType$str()), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String gridDialectPropertyOfUnknownType$str() {
        return gridDialectPropertyOfUnknownType;
    }

    public final org.hibernate.HibernateException illegalDiscrimantorType(final String arg0) {
        org.hibernate.HibernateException result = new org.hibernate.HibernateException(String.format(((projectCode +"000026: ")+ illegalDiscrimantorType$str()), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String illegalDiscrimantorType$str() {
        return illegalDiscrimantorType;
    }

    public final org.hibernate.HibernateException unableToInstantiateQueryParserService(final String arg0, final Exception arg1) {
        org.hibernate.HibernateException result = new org.hibernate.HibernateException(String.format(((projectCode +"000030: ")+ unableToInstantiateQueryParserService$str()), arg0), arg1);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToInstantiateQueryParserService$str() {
        return unableToInstantiateQueryParserService;
    }

    public final void version(final String arg0) {
        super.log.logf(FQCN, (Logger.Level.INFO), null, ((projectCode +"000001: ")+ version$str()), arg0);
    }

    protected String version$str() {
        return version;
    }

    public final org.hibernate.HibernateException mongoDbNameMissing() {
        org.hibernate.HibernateException result = new org.hibernate.HibernateException(String.format(((projectCode +"001208: ")+ mongoDbNameMissing$str())));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mongoDbNameMissing$str() {
        return mongoDbNameMissing;
    }

    public final org.hibernate.HibernateException doesNotImplementGridDialect(final String arg0) {
        org.hibernate.HibernateException result = new org.hibernate.HibernateException(String.format(((projectCode +"000013: ")+ doesNotImplementGridDialect$str()), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String doesNotImplementGridDialect$str() {
        return doesNotImplementGridDialect;
    }

    public final org.hibernate.HibernateException mappingSubtypeNotInterface(final Class arg0) {
        org.hibernate.HibernateException result = new org.hibernate.HibernateException(String.format(((projectCode +"000032: ")+ mappingSubtypeNotInterface$str()), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mappingSubtypeNotInterface$str() {
        return mappingSubtypeNotInterface;
    }

    public final void removedAssociation(final int nAffected) {
        super.log.logf(FQCN, (Logger.Level.TRACE), null, ((projectCode +"001210: ")+ removedAssociation$str()), nAffected);
    }

    protected String removedAssociation$str() {
        return removedAssociation;
    }

    public final org.hibernate.TransactionException jtaRollbackFailed(final Exception arg0) {
        org.hibernate.TransactionException result = new org.hibernate.TransactionException(String.format(((projectCode +"000020: ")+ jtaRollbackFailed$str())), arg0);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String jtaRollbackFailed$str() {
        return jtaRollbackFailed;
    }

    public final org.hibernate.TransactionException unableToSetTimeout(final javax.transaction.SystemException arg0, final int arg1) {
        org.hibernate.TransactionException result = new org.hibernate.TransactionException(String.format(((projectCode +"000023: ")+ unableToSetTimeout$str()), arg1), arg0);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToSetTimeout$str() {
        return unableToSetTimeout;
    }

    public final void usingDefaultTransactionFactory() {
        super.log.logf(FQCN, (Logger.Level.INFO), null, ((projectCode +"000003: ")+ usingDefaultTransactionFactory$str()));
    }

    protected String usingDefaultTransactionFactory$str() {
        return usingDefaultTransactionFactory;
    }

    public final org.hibernate.HibernateException cannotInstantiateGridDialect(final Class arg0, final Exception arg1) {
        org.hibernate.HibernateException result = new org.hibernate.HibernateException(String.format(((projectCode +"000011: ")+ cannotInstantiateGridDialect$str()), arg0), arg1);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotInstantiateGridDialect$str() {
        return cannotInstantiateGridDialect;
    }

    public final org.hibernate.HibernateException cannotCreatePropertyContextProxy(final Class arg0, final Exception arg1) {
        org.hibernate.HibernateException result = new org.hibernate.HibernateException(String.format(((projectCode +"000039: ")+ cannotCreatePropertyContextProxy$str()), arg0), arg1);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotCreatePropertyContextProxy$str() {
        return cannotCreatePropertyContextProxy;
    }

    public final void connectingToMongo(final String host, final int port, final int timeout) {
        super.log.logf(FQCN, (Logger.Level.INFO), null, ((projectCode +"001201: ")+ connectingToMongo$str()), host, port, timeout);
    }

    protected String connectingToMongo$str() {
        return connectingToMongo;
    }

    public final void createdQuery(final String arg0, final Object arg1) {
        super.log.logf(FQCN, (Logger.Level.DEBUG), null, ((projectCode +"000028: ")+ createdQuery$str()), arg0, arg1);
    }

    protected String createdQuery$str() {
        return createdQuery;
    }

    public final org.hibernate.HibernateException gridDialectHasNoProperConstrutor(final Class arg0) {
        org.hibernate.HibernateException result = new org.hibernate.HibernateException(String.format(((projectCode +"000014: ")+ gridDialectHasNoProperConstrutor$str()), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String gridDialectHasNoProperConstrutor$str() {
        return gridDialectHasNoProperConstrutor;
    }

    public final org.hibernate.HibernateException getPropertyDoesNotExistException(final String arg0, final String arg1, final ElementType arg2) {
        org.hibernate.HibernateException result = new org.hibernate.HibernateException(String.format(((projectCode +"000041: ")+ getPropertyDoesNotExistException$str()), arg0, arg1, arg2));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getPropertyDoesNotExistException$str() {
        return getPropertyDoesNotExistException;
    }

    public final org.hibernate.HibernateException cannotCreateGlobalContextProxy(final Class arg0, final Exception arg1) {
        org.hibernate.HibernateException result = new org.hibernate.HibernateException(String.format(((projectCode +"000037: ")+ cannotCreateGlobalContextProxy$str()), arg0), arg1);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotCreateGlobalContextProxy$str() {
        return cannotCreateGlobalContextProxy;
    }

    public final org.hibernate.HibernateException getUnsupportedElementTypeException(final ElementType arg0) {
        org.hibernate.HibernateException result = new org.hibernate.HibernateException(String.format(((projectCode +"000042: ")+ getUnsupportedElementTypeException$str()), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnsupportedElementTypeException$str() {
        return getUnsupportedElementTypeException;
    }

    public final org.hibernate.HibernateException authenticationFailed(final String username) {
        org.hibernate.HibernateException result = new org.hibernate.HibernateException(String.format(((projectCode +"001213: ")+ authenticationFailed$str()), username));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String authenticationFailed$str() {
        return authenticationFailed;
    }

    public final org.hibernate.HibernateException datastoreClassCannotBeFound(final String arg0, final String arg1) {
        org.hibernate.HibernateException result = new org.hibernate.HibernateException(String.format(((projectCode +"000008: ")+ datastoreClassCannotBeFound$str()), arg0, arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String datastoreClassCannotBeFound$str() {
        return datastoreClassCannotBeFound;
    }

    public final void unsupportedIndexerConfigurationOption(final String arg0) {
        super.log.logf(FQCN, (Logger.Level.WARN), null, ((projectCode +"000031: ")+ unsupportedIndexerConfigurationOption$str()), arg0);
    }

    protected String unsupportedIndexerConfigurationOption$str() {
        return unsupportedIndexerConfigurationOption;
    }

    public final org.hibernate.HibernateException unableToInstantiateDatastoreManager(final String arg0, final Exception arg1) {
        org.hibernate.HibernateException result = new org.hibernate.HibernateException(String.format(((projectCode +"000006: ")+ unableToInstantiateDatastoreManager$str()), arg0), arg1);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToInstantiateDatastoreManager$str() {
        return unableToInstantiateDatastoreManager;
    }

}
