/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.infinispan.persistencestrategy.kind.externalizer.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.hibernate.ogm.datastore.infinispan.persistencestrategy.common.externalizer.impl.VersionChecker;
import org.hibernate.ogm.model.impl.DefaultEntityKeyMetadata;
import org.hibernate.ogm.model.key.spi.EntityKey;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.infinispan.commons.marshall.AdvancedExternalizer;

public class EntityKeyExternalizer
implements AdvancedExternalizer<EntityKey> {
    public static final EntityKeyExternalizer INSTANCE = new EntityKeyExternalizer();
    private static final int VERSION = 1;
    private static final Set<Class<? extends EntityKey>> TYPE_CLASSES = Collections.singleton(EntityKey.class);

    private EntityKeyExternalizer() {
    }

    public void writeObject(ObjectOutput output, EntityKey key) throws IOException {
        output.writeInt(1);
        output.writeUTF(key.getTable());
        output.writeObject(key.getColumnNames());
        output.writeObject(key.getColumnValues());
    }

    public EntityKey readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        VersionChecker.readAndCheckVersion(input, 1, EntityKey.class);
        String tableName = input.readUTF();
        String[] columnNames = (String[])input.readObject();
        Object[] values = (Object[])input.readObject();
        return new EntityKey((EntityKeyMetadata)new DefaultEntityKeyMetadata(tableName, columnNames), values);
    }

    public Set<Class<? extends EntityKey>> getTypeClasses() {
        return TYPE_CLASSES;
    }

    public Integer getId() {
        return 1400;
    }
}

