/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.infinispan.configuration.impl;

import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.util.Map;
import org.hibernate.ogm.util.configurationreader.spi.ConfigurationPropertyReader;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;

public class InfinispanConfiguration {
    private static final Log log = LoggerFactory.make((MethodHandles.Lookup)MethodHandles.lookup());
    private static final String INFINISPAN_DEFAULT_CONFIG = "org/hibernate/ogm/datastore/infinispan/default-config.xml";
    private URL configUrl;
    private String jndi;

    public URL getConfigurationUrl() {
        return this.configUrl;
    }

    public String getJndiName() {
        return this.jndi;
    }

    public void initConfiguration(Map<?, ?> configurationMap) {
        ConfigurationPropertyReader propertyReader = new ConfigurationPropertyReader(configurationMap);
        this.configUrl = (URL)propertyReader.property("hibernate.ogm.infinispan.configuration_resource_name", URL.class).withDefault((Object)InfinispanConfiguration.class.getClassLoader().getResource(INFINISPAN_DEFAULT_CONFIG)).getValue();
        this.jndi = (String)propertyReader.property("hibernate.ogm.infinispan.cachemanager_jndi_name", String.class).getValue();
        log.tracef("Initializing Infinispan from configuration file at %1$s", (Object)this.configUrl);
    }
}

