/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal;

import java.util.Collection;
import org.hibernate.models.internal.TypeDetailsSwitchSupport;
import org.hibernate.models.internal.TypeDetailsSwitcher;
import org.hibernate.models.spi.ClassBasedTypeDetails;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.ClassTypeDetails;
import org.hibernate.models.spi.ParameterizedTypeDetails;
import org.hibernate.models.spi.TypeDetails;
import org.hibernate.models.spi.TypeVariableDetails;
import org.hibernate.models.spi.TypeVariableReferenceDetails;
import org.hibernate.models.spi.WildcardTypeDetails;

public class CollectionElementSwitch
extends TypeDetailsSwitchSupport<TypeDetails> {
    private final TypeDetails memberTypeDetails;

    public static TypeDetails extractCollectionElementType(TypeDetails memberType) {
        TypeDetails typeDetails;
        assert (memberType.isImplementor(Collection.class));
        ClassDetails rawClassDetails = memberType.determineRawClass();
        CollectionElementSwitch collectionElementSwitch = new CollectionElementSwitch(memberType);
        if (rawClassDetails.getGenericSuperType() != null && (typeDetails = TypeDetailsSwitcher.switchType(rawClassDetails.getGenericSuperType(), collectionElementSwitch)) != null) {
            return typeDetails;
        }
        for (TypeDetails implementedInterface : rawClassDetails.getImplementedInterfaces()) {
            TypeDetails typeDetails2 = TypeDetailsSwitcher.switchType(implementedInterface, collectionElementSwitch);
            if (typeDetails2 == null) continue;
            return typeDetails2;
        }
        return ClassBasedTypeDetails.OBJECT_TYPE_DETAILS;
    }

    private CollectionElementSwitch(TypeDetails memberTypeDetails) {
        this.memberTypeDetails = memberTypeDetails;
    }

    @Override
    public TypeDetails caseClass(ClassTypeDetails classType) {
        if (classType.isImplementor(Collection.class) && classType.getClassDetails().getGenericSuperType() != null) {
            return TypeDetailsSwitcher.switchType(classType.getClassDetails().getGenericSuperType(), this);
        }
        return null;
    }

    @Override
    public TypeDetails caseParameterizedType(ParameterizedTypeDetails parameterizedType) {
        if (parameterizedType.isImplementor(Collection.class)) {
            return parameterizedType.getArguments().get(0);
        }
        return null;
    }

    @Override
    public TypeDetails caseWildcardType(WildcardTypeDetails wildcardType) {
        if (wildcardType.isImplementor(Collection.class)) {
            return wildcardType.getBound();
        }
        return null;
    }

    @Override
    public TypeDetails caseTypeVariable(TypeVariableDetails typeVariable) {
        if (typeVariable.isImplementor(Collection.class)) {
            return this.memberTypeDetails.resolveTypeVariable(typeVariable);
        }
        return null;
    }

    @Override
    public TypeDetails caseTypeVariableReference(TypeVariableReferenceDetails typeVariableReference) {
        if (typeVariableReference.isImplementor(Collection.class)) {
            return this.memberTypeDetails.resolveTypeVariable(typeVariableReference.getTarget());
        }
        return null;
    }
}

