/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.jandex.internal.values;

import java.util.List;
import org.hibernate.models.jandex.spi.JandexModelsContext;
import org.hibernate.models.jandex.spi.JandexValueConverter;
import org.hibernate.models.spi.ModelsContext;
import org.hibernate.models.spi.ValueTypeDescriptor;
import org.jboss.jandex.AnnotationValue;

public class ArrayValueConverter<V>
implements JandexValueConverter<V[]> {
    private final ValueTypeDescriptor<V> elementTypeDescriptor;

    public ArrayValueConverter(ValueTypeDescriptor<V> elementTypeDescriptor) {
        this.elementTypeDescriptor = elementTypeDescriptor;
    }

    @Override
    public V[] convert(AnnotationValue jandexValue, ModelsContext modelContext) {
        assert (jandexValue != null);
        List values = jandexValue.asArrayList();
        assert (values != null);
        Object[] result = this.elementTypeDescriptor.makeArray(values.size(), modelContext);
        JandexValueConverter<V> elementWrapper = ((JandexModelsContext)modelContext.as(JandexModelsContext.class)).getJandexValueConverter(this.elementTypeDescriptor);
        for (int i = 0; i < values.size(); ++i) {
            result[i] = elementWrapper.convert((AnnotationValue)values.get(i), modelContext);
        }
        return result;
    }
}

