/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.infra.develocity.plugins;

import com.gradle.develocity.agent.maven.api.cache.MojoMetadataProvider;
import java.util.Map;
import org.hibernate.infra.develocity.GoalMetadataProvider;
import org.hibernate.infra.develocity.plugins.SurefireConfiguredPlugin;
import org.hibernate.infra.develocity.scan.BuildScanMetadata;

public class FailsafeConfiguredPlugin
extends SurefireConfiguredPlugin {
    @Override
    protected String getPluginName() {
        return "maven-failsafe-plugin";
    }

    @Override
    protected Map<String, GoalMetadataProvider> getGoalMetadataProviders() {
        return Map.of("integration-test", this::configureIntegrationTest);
    }

    private void configureIntegrationTest(GoalMetadataProvider.Context context) {
        this.configureTest(context);
        context.metadata().inputs(inputs -> {
            String repackagedJarPath;
            String containersPath = context.configuration().getFailsafeSystemProperty("org.hibernate.search.integrationtest.container.directory");
            if (containersPath != null) {
                inputs.fileSet("containers", (Object)containersPath, fileSet -> fileSet.normalizationStrategy(MojoMetadataProvider.Context.FileSet.NormalizationStrategy.RELATIVE_PATH));
            }
            if ((repackagedJarPath = context.configuration().getFailsafeSystemProperty("test.repackaged-jar-path")) != null) {
                inputs.fileSet("repackaged-jar", (Object)repackagedJarPath, fileSet -> fileSet.normalizationStrategy(MojoMetadataProvider.Context.FileSet.NormalizationStrategy.RELATIVE_PATH));
            }
        });
        if (!this.isSkipped(context)) {
            BuildScanMetadata.addFailsafeMetadata(context);
        }
    }

    @Override
    protected boolean isSkipped(GoalMetadataProvider.Context context) {
        return context.configuration().getBoolean("skip") != false || context.properties().getBoolean("maven.test.skip") != false || context.configuration().getBoolean("skipITs") != false || context.properties().getBoolean("skipITs") != false || context.configuration().getBoolean("skipTests") != false || context.properties().getBoolean("skipTests") != false || context.configuration().getBoolean("skipExec") != false || context.properties().getBoolean("maven.test.skip.exec") != false;
    }
}

