/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.infra.develocity.util;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class JavaVersions {
    private static final Pattern JDK_VERSION_MAJOR_PATTERN = Pattern.compile("^.*version \"(\\d+).*$", 32);
    private static final Pattern JDK_VERSION_MAJOR_FALLBACK_PATTERN = Pattern.compile("(\\d+)\\.");
    private static final Map<String, String> versionByExecutablePath = new ConcurrentHashMap<String, String>();

    private JavaVersions() {
    }

    public static String forJavaExecutable(String javaPath) {
        if (javaPath == null || javaPath.isBlank()) {
            return Runtime.version().toString();
        }
        return JavaVersions.forExecutable(javaPath);
    }

    public static String forJavacExecutable(String javacPath) {
        if (javacPath == null || javacPath.isBlank()) {
            return Runtime.version().toString();
        }
        return JavaVersions.forExecutable(javacPath) + JavaVersions.forExecutable(javacPath.replaceAll("/javac$", "/java"));
    }

    private static String forExecutable(String executablePath) {
        return versionByExecutablePath.computeIfAbsent(executablePath, path -> {
            ProcessBuilder builder = new ProcessBuilder(new String[0]);
            builder.command((String)path, "-version");
            builder.environment().remove("JAVA_TOOL_OPTIONS");
            try {
                Process process = builder.start();
                int exitCode = process.waitFor();
                if (exitCode != 0) {
                    throw new IllegalStateException(executablePath + " exited with code " + exitCode);
                }
                return new String(process.getInputStream().readAllBytes(), StandardCharsets.UTF_8) + new String(process.getErrorStream().readAllBytes(), StandardCharsets.UTF_8);
            }
            catch (IOException | InterruptedException | RuntimeException e) {
                throw new IllegalStateException("Cannot guess java version for " + executablePath, e);
            }
        });
    }

    public static String toJdkMajor(String fullVersionText, String defaultValue) {
        Matcher matcher = JDK_VERSION_MAJOR_PATTERN.matcher(fullVersionText);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        matcher = JDK_VERSION_MAJOR_FALLBACK_PATTERN.matcher(fullVersionText);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return defaultValue;
    }
}

