/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.infra.develocity;

import com.gradle.develocity.agent.maven.api.cache.MojoMetadataProvider;
import com.gradle.develocity.agent.maven.api.scan.BuildScanApi;
import java.util.function.Consumer;
import org.hibernate.infra.develocity.util.MavenMojoExecutionConfig;
import org.hibernate.infra.develocity.util.MavenProperties;

@FunctionalInterface
public interface GoalMetadataProvider {
    public void configure(Context var1);

    public static class Context {
        private final BuildScanApi buildScanApi;
        private final MojoMetadataProvider.Context metadataContext;
        private final MavenProperties properties;
        private final MavenMojoExecutionConfig configuration;

        public Context(BuildScanApi buildScanApi, MojoMetadataProvider.Context metadataContext) {
            this.buildScanApi = buildScanApi;
            this.metadataContext = metadataContext;
            this.properties = new MavenProperties(metadataContext.getSession(), metadataContext.getMojoExecution());
            this.configuration = new MavenMojoExecutionConfig(metadataContext.getMojoExecution());
        }

        public BuildScanApi buildScan() {
            return this.buildScanApi;
        }

        public MojoMetadataProvider.Context metadata() {
            return this.metadataContext;
        }

        public MavenProperties properties() {
            return this.properties;
        }

        public MavenMojoExecutionConfig configuration() {
            return this.configuration;
        }

        public void buildScanDeduplicatedValue(String key, String value) {
            this.buildScanApi.executeOnce(key + value, ignored -> this.buildScanApi.value(key, value));
        }

        public void nested(String propertyName, Consumer<? super Context> action) {
            this.metadataContext.nested(propertyName, nestedMetadataContext -> action.accept(new Context(this.buildScanApi, (MojoMetadataProvider.Context)nestedMetadataContext)));
        }
    }
}

