/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.lucene.internal.builder.predicate;

import org.apache.lucene.search.Query;
import org.hibernate.hql.ast.spi.predicate.ComparisonPredicate;
import org.hibernate.search.query.dsl.QueryBuilder;

public class LuceneComparisonPredicate
extends ComparisonPredicate<Query> {
    private final QueryBuilder builder;

    public LuceneComparisonPredicate(QueryBuilder builder, String propertyName, ComparisonPredicate.Type comparisonType, Object value) {
        super(propertyName, comparisonType, value);
        this.builder = builder;
    }

    protected Query getStrictlyLessQuery() {
        return this.builder.range().onField(this.propertyName).below(this.value).excludeLimit().createQuery();
    }

    protected Query getLessOrEqualsQuery() {
        return this.builder.range().onField(this.propertyName).below(this.value).createQuery();
    }

    protected Query getEqualsQuery() {
        return this.builder.keyword().onField(this.propertyName).matching(this.value).createQuery();
    }

    protected Query getGreaterOrEqualsQuery() {
        return this.builder.range().onField(this.propertyName).above(this.value).createQuery();
    }

    protected Query getStrictlyGreaterQuery() {
        return this.builder.range().onField(this.propertyName).above(this.value).excludeLimit().createQuery();
    }
}

