/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mvn;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.tools.ant.BuildException;
import org.hibernate.cfg.reveng.OverrideRepository;
import org.hibernate.cfg.reveng.ReverseEngineeringSettings;
import org.hibernate.cfg.reveng.ReverseEngineeringStrategy;
import org.hibernate.tool.api.metadata.MetadataDescriptor;
import org.hibernate.tool.api.metadata.MetadataDescriptorFactory;

public abstract class AbstractHbm2xMojo
extends AbstractMojo {
    @Parameter
    private String packageName;
    @Parameter
    private File revengFile;
    @Parameter(defaultValue="org.hibernate.cfg.reveng.DefaultReverseEngineeringStrategy")
    private String revengStrategy;
    @Parameter(defaultValue="true")
    private boolean detectManyToMany;
    @Parameter(defaultValue="true")
    private boolean detectOneToOne;
    @Parameter(defaultValue="true")
    private boolean detectOptimisticLock;
    @Parameter(defaultValue="true")
    private boolean createCollectionForForeignKey;
    @Parameter(defaultValue="true")
    private boolean createManyToOneForForeignKey;
    @Parameter(defaultValue="${project.basedir}/src/main/hibernate/hibernate.properties")
    private File propertyFile;
    private boolean preferBasicCompositeIds = true;

    public void execute() {
        this.getLog().info((CharSequence)("Starting " + ((Object)((Object)this)).getClass().getSimpleName() + "..."));
        ReverseEngineeringStrategy strategy = this.setupReverseEngineeringStrategy();
        Properties properties = this.loadPropertiesFile();
        MetadataDescriptor jdbcDescriptor = this.createJdbcDescriptor(strategy, properties);
        this.executeExporter(jdbcDescriptor);
        this.getLog().info((CharSequence)("Finished " + ((Object)((Object)this)).getClass().getSimpleName() + "!"));
    }

    private ReverseEngineeringStrategy setupReverseEngineeringStrategy() {
        ReverseEngineeringStrategy strategy;
        try {
            strategy = (ReverseEngineeringStrategy)ReverseEngineeringStrategy.class.cast(Class.forName(this.revengStrategy).newInstance());
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new BuildException(this.revengStrategy + " not instanced.", (Throwable)e);
        }
        if (this.revengFile != null) {
            OverrideRepository override = new OverrideRepository();
            override.addFile(this.revengFile);
            strategy = override.getReverseEngineeringStrategy(strategy);
        }
        ReverseEngineeringSettings settings = new ReverseEngineeringSettings(strategy).setDefaultPackageName(this.packageName).setDetectManyToMany(this.detectManyToMany).setDetectOneToOne(this.detectOneToOne).setDetectOptimisticLock(this.detectOptimisticLock).setCreateCollectionForForeignKey(this.createCollectionForForeignKey).setCreateManyToOneForForeignKey(this.createManyToOneForForeignKey);
        strategy.setSettings(settings);
        return strategy;
    }

    private Properties loadPropertiesFile() {
        Properties properties;
        if (this.propertyFile == null) {
            return null;
        }
        Properties properties2 = new Properties();
        FileInputStream is = new FileInputStream(this.propertyFile);
        try {
            properties2.load(is);
            properties = properties2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                throw new BuildException(this.propertyFile + " not found.", (Throwable)e);
            }
            catch (IOException e) {
                throw new BuildException("Problem while loading " + this.propertyFile, (Throwable)e);
            }
        }
        is.close();
        return properties;
    }

    private MetadataDescriptor createJdbcDescriptor(ReverseEngineeringStrategy strategy, Properties properties) {
        return MetadataDescriptorFactory.createJdbcDescriptor((ReverseEngineeringStrategy)strategy, (Properties)properties, (boolean)this.preferBasicCompositeIds);
    }

    protected abstract void executeExporter(MetadataDescriptor var1);
}

