/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.orm.junit;

import org.jboss.logging.Logger;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class ClassLoadingIsolaterExtension
implements AfterEachCallback,
BeforeEachCallback {
    private static final Logger log = Logger.getLogger(ClassLoadingIsolaterExtension.class);
    private IsolatedClassLoaderProvider provider;
    private ClassLoader isolatedClassLoader;
    private ClassLoader originalTCCL;

    public void afterEach(ExtensionContext context) throws Exception {
        assert (Thread.currentThread().getContextClassLoader() == this.isolatedClassLoader);
        log.infof("Reverting TCCL [%s] -> [%s]", (Object)this.isolatedClassLoader, (Object)this.originalTCCL);
        Thread.currentThread().setContextClassLoader(this.originalTCCL);
        this.provider.releaseIsolatedClassLoader(this.isolatedClassLoader);
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        Object testInstance = context.getTestInstance().get();
        if (!(testInstance instanceof IsolatedClassLoaderProvider)) {
            throw new RuntimeException("Test @ExtendWith( ClassLoadingIsolaterExtension.class ) have to implement ClassLoadingIsolaterExtension.IsolatedClassLoaderProvider");
        }
        this.provider = (IsolatedClassLoaderProvider)testInstance;
        this.originalTCCL = Thread.currentThread().getContextClassLoader();
        this.isolatedClassLoader = this.provider.buildIsolatedClassLoader();
        log.infof("Overriding TCCL [%s] -> [%s]", (Object)this.originalTCCL, (Object)this.isolatedClassLoader);
        Thread.currentThread().setContextClassLoader(this.isolatedClassLoader);
    }

    public static interface IsolatedClassLoaderProvider {
        public ClassLoader buildIsolatedClassLoader();

        public void releaseIsolatedClassLoader(ClassLoader var1);
    }
}

