/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.orm.domain.animal;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.MapKeyColumn;
import javax.persistence.OneToMany;
import org.hibernate.testing.orm.domain.animal.Address;
import org.hibernate.testing.orm.domain.animal.Animal;
import org.hibernate.testing.orm.domain.animal.Classification;
import org.hibernate.testing.orm.domain.animal.Human;
import org.hibernate.testing.orm.domain.animal.Mammal;

@Entity
@Inheritance
@DiscriminatorColumn(name="zooType")
@DiscriminatorValue(value="Z")
public class Zoo {
    private Long id;
    private String name;
    private Classification classification;
    private Map directors = new HashMap();
    private Map animals = new HashMap();
    private Map mammals = new HashMap();
    private Address address;

    public Zoo() {
    }

    public Zoo(String name, Address address) {
        this.name = name;
        this.address = address;
    }

    @Id
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ManyToMany
    @JoinTable(name="t_directors", joinColumns={@JoinColumn(name="zoo_fk")}, inverseJoinColumns={@JoinColumn(name="director_fk")})
    @MapKeyColumn(name="`title`")
    public Map<String, Human> getDirectors() {
        return this.directors;
    }

    public void setDirectors(Map directors) {
        this.directors = directors;
    }

    @OneToMany
    @JoinColumn(name="mammal_fk")
    @MapKeyColumn(name="name")
    public Map<String, Mammal> getMammals() {
        return this.mammals;
    }

    public void setMammals(Map mammals) {
        this.mammals = mammals;
    }

    @OneToMany(mappedBy="zoo")
    @MapKeyColumn(name="serialNumber")
    public Map<String, Animal> getAnimals() {
        return this.animals;
    }

    public void setAnimals(Map animals) {
        this.animals = animals;
    }

    @Embedded
    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    @Enumerated(value=EnumType.STRING)
    public Classification getClassification() {
        return this.classification;
    }

    public void setClassification(Classification classification) {
        this.classification = classification;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Zoo)) {
            return false;
        }
        Zoo zoo = (Zoo)o;
        if (this.address != null ? !this.address.equals(zoo.address) : zoo.address != null) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(zoo.name) : zoo.name != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.address != null ? this.address.hashCode() : 0);
        return result;
    }
}

