/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.boot;

import java.sql.Connection;
import java.sql.SQLException;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.jdbc.connections.spi.JdbcConnectionAccess;
import org.hibernate.service.ServiceRegistry;

public class JdbcConnectionAccessImpl
implements JdbcConnectionAccess {
    private final ConnectionProvider connectionProvider;

    public JdbcConnectionAccessImpl(ConnectionProvider connectionProvider) {
        this.connectionProvider = connectionProvider;
    }

    public JdbcConnectionAccessImpl(ServiceRegistry serviceRegistry) {
        this((ConnectionProvider)serviceRegistry.getService(ConnectionProvider.class));
    }

    public Connection obtainConnection() throws SQLException {
        return this.connectionProvider.getConnection();
    }

    public void releaseConnection(Connection connection) throws SQLException {
        this.connectionProvider.closeConnection(connection);
    }

    public boolean supportsAggressiveRelease() {
        return this.connectionProvider.supportsAggressiveRelease();
    }
}

