/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.hibernate.engine.jdbc.connections.internal.ConnectionProviderInitiator;
import org.hibernate.engine.jdbc.connections.internal.DriverManagerConnectionProviderImpl;
import org.hibernate.internal.util.config.ConfigurationHelper;

public class SharedDriverManagerConnectionProviderImpl
extends DriverManagerConnectionProviderImpl {
    private static final SharedDriverManagerConnectionProviderImpl INSTANCE = new SharedDriverManagerConnectionProviderImpl();
    private Config config;
    private Boolean supportsIsValid;

    public static SharedDriverManagerConnectionProviderImpl getInstance() {
        return INSTANCE;
    }

    public void configure(Map configurationValues) {
        Config c = new Config(configurationValues);
        if (!c.isCompatible(this.config)) {
            if (this.config != null) {
                super.stop();
            }
            super.configure(configurationValues);
            this.config = c;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid(Connection connection) throws SQLException {
        if (this.supportsIsValid == Boolean.FALSE) {
            return true;
        }
        Boolean supportsIsValid = Boolean.FALSE;
        try {
            boolean valid = connection.isValid(5);
            supportsIsValid = Boolean.TRUE;
            boolean bl = valid;
            return bl;
        }
        catch (AbstractMethodError e) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.supportsIsValid = supportsIsValid;
        }
    }

    public void stop() {
        this.validateConnectionsReturned();
    }

    public void reset() {
        super.stop();
    }

    private static class Config {
        private final boolean autoCommit;
        private final int minSize;
        private final int maxSize;
        private final int initialSize;
        private final String driverClassName;
        private final String url;
        private final Properties connectionProps;
        private final Integer isolation;

        public Config(Map<String, Object> configurationValues) {
            this.autoCommit = ConfigurationHelper.getBoolean((String)"hibernate.connection.autocommit", configurationValues, (boolean)false);
            this.minSize = ConfigurationHelper.getInt((String)"hibernate.connection.min_pool_size", configurationValues, (int)2);
            this.maxSize = ConfigurationHelper.getInt((String)"hibernate.connection.pool_size", configurationValues, (int)20);
            this.initialSize = ConfigurationHelper.getInt((String)"hibernate.connection.initial_pool_size", configurationValues, (int)this.minSize);
            this.driverClassName = (String)configurationValues.get("hibernate.connection.driver_class");
            this.url = (String)configurationValues.get("hibernate.connection.url");
            this.connectionProps = ConnectionProviderInitiator.getConnectionProperties(configurationValues);
            this.isolation = ConnectionProviderInitiator.extractIsolation(configurationValues);
        }

        boolean isCompatible(Config config) {
            return config != null && this.autoCommit == config.autoCommit && this.minSize == config.minSize && this.maxSize == config.maxSize && this.initialSize == config.initialSize && this.driverClassName.equals(config.driverClassName) && this.url.equals(config.url) && this.connectionProps.equals(config.connectionProps) && Objects.equals(this.isolation, config.isolation);
        }
    }
}

