/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.cleaner;

import java.sql.Connection;
import java.sql.SQLException;
import org.hibernate.testing.cleaner.AbstractMySQLDatabaseCleaner;

public class MariaDBDatabaseCleaner
extends AbstractMySQLDatabaseCleaner {
    @Override
    public boolean isApplicable(Connection connection) {
        try {
            return connection.getMetaData().getDatabaseProductName().equals("MariaDB") && connection.getMetaData().getDriverName().startsWith("MariaDB");
        }
        catch (SQLException e) {
            throw new RuntimeException("Could not resolve the database metadata!", e);
        }
    }

    @Override
    protected String createClearingStatementForTable(String tableSchema, String tableName) {
        return "TRUNCATE " + tableSchema + "." + tableName;
    }
}

