/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.junit4;

import org.hibernate.testing.FailureExpected;
import org.hibernate.testing.junit4.ExtendedFrameworkMethod;
import org.hibernate.testing.junit4.Helper;
import org.hibernate.testing.junit4.TestClassMetadata;
import org.jboss.logging.Logger;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

class FailureExpectedHandler
extends Statement {
    private static final Logger log = Logger.getLogger(FailureExpectedHandler.class);
    private final TestClassMetadata testClassMetadata;
    private final ExtendedFrameworkMethod extendedFrameworkMethod;
    private final Statement realInvoker;
    private final Object testInstance;

    public FailureExpectedHandler(Statement realInvoker, TestClassMetadata testClassMetadata, ExtendedFrameworkMethod extendedFrameworkMethod, Object testInstance) {
        this.realInvoker = realInvoker;
        this.testClassMetadata = testClassMetadata;
        this.extendedFrameworkMethod = extendedFrameworkMethod;
        this.testInstance = testInstance;
    }

    public void evaluate() throws Throwable {
        FailureExpected failureExpected = this.extendedFrameworkMethod.getFailureExpectedAnnotation();
        try {
            this.realInvoker.evaluate();
            if (failureExpected != null) {
                throw new FailureExpectedTestPassedException(this.extendedFrameworkMethod);
            }
        }
        catch (FailureExpectedTestPassedException e) {
            throw e;
        }
        catch (Throwable e) {
            if (failureExpected != null) {
                log.infof("Ignoring expected failure [%s] : %s", (Object)Helper.extractTestName(this.extendedFrameworkMethod), (Object)Helper.extractMessage(failureExpected));
                this.testClassMetadata.performOnExpectedFailureCallback(this.testInstance);
            }
            this.testClassMetadata.performOnFailureCallback(this.testInstance);
            throw e;
        }
    }

    public static class FailureExpectedTestPassedException
    extends Exception {
        public FailureExpectedTestPassedException(FrameworkMethod frameworkMethod) {
            super("Test marked as FailureExpected, but did not fail : " + Helper.extractTestName(frameworkMethod));
        }
    }
}

