/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.engine.jdbc.connections.internal.ConnectionProviderInitiator;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.ServiceRegistryAwareService;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.Stoppable;

public class ConnectionProviderDelegate
implements ConnectionProvider,
Configurable,
ServiceRegistryAwareService,
Stoppable {
    private ServiceRegistryImplementor serviceRegistry;
    private ConnectionProvider connectionProvider;

    public ConnectionProviderDelegate() {
    }

    public ConnectionProviderDelegate(ConnectionProvider connectionProvider) {
        this.connectionProvider = connectionProvider;
    }

    public void injectServices(ServiceRegistryImplementor serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public void configure(Map configurationValues) {
        if (this.connectionProvider == null) {
            HashMap settings = new HashMap(configurationValues);
            settings.remove("hibernate.connection.provider_class");
            this.connectionProvider = ConnectionProviderInitiator.INSTANCE.initiateService(settings, this.serviceRegistry);
            if (this.connectionProvider instanceof Configurable) {
                Configurable configurableConnectionProvider = (Configurable)this.connectionProvider;
                configurableConnectionProvider.configure(settings);
            }
        }
    }

    public Connection getConnection() throws SQLException {
        return this.connectionProvider.getConnection();
    }

    public void closeConnection(Connection conn) throws SQLException {
        this.connectionProvider.closeConnection(conn);
    }

    public boolean supportsAggressiveRelease() {
        return this.connectionProvider.supportsAggressiveRelease();
    }

    public boolean isUnwrappableAs(Class unwrapType) {
        return this.connectionProvider.isUnwrappableAs(unwrapType);
    }

    public <T> T unwrap(Class<T> unwrapType) {
        return (T)this.connectionProvider.unwrap(unwrapType);
    }

    public void stop() {
        if (this.connectionProvider instanceof Stoppable) {
            ((Stoppable)this.connectionProvider).stop();
        }
    }
}

