/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.jdbc.leak;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.MySQL5Dialect;
import org.hibernate.testing.jdbc.leak.IdleConnectionCounter;

public class MySQLIdleConnectionCounter
implements IdleConnectionCounter {
    public static final IdleConnectionCounter INSTANCE = new MySQLIdleConnectionCounter();

    @Override
    public boolean appliesTo(Class<? extends Dialect> dialect) {
        return MySQL5Dialect.class.isAssignableFrom(dialect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int count(Connection connection) {
        Statement statement = null;
        try {
            int n;
            statement = connection.createStatement();
            ResultSet resultSet = null;
            try {
                resultSet = statement.executeQuery("SHOW PROCESSLIST");
                int count = 0;
                while (resultSet.next()) {
                    String state = resultSet.getString("command");
                    if (!"sleep".equalsIgnoreCase(state)) continue;
                    ++count;
                }
                n = count;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        if (resultSet == null) throw throwable;
                        resultSet.close();
                        throw throwable;
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new IllegalStateException(e);
                }
            }
            try {
                if (resultSet == null) return n;
                resultSet.close();
                return n;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            return n;
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }
}

