/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.cache;

import org.hibernate.cache.internal.DefaultCacheKeysFactory;
import org.hibernate.cache.spi.CollectionRegion;
import org.hibernate.cache.spi.access.CollectionRegionAccessStrategy;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.testing.cache.BaseGeneralDataRegion;
import org.hibernate.testing.cache.BaseRegionAccessStrategy;
import org.hibernate.testing.cache.CollectionRegionImpl;

class BaseCollectionRegionAccessStrategy
extends BaseRegionAccessStrategy
implements CollectionRegionAccessStrategy {
    private final CollectionRegionImpl region;

    BaseCollectionRegionAccessStrategy(CollectionRegionImpl region) {
        this.region = region;
    }

    @Override
    protected BaseGeneralDataRegion getInternalRegion() {
        return this.region;
    }

    @Override
    protected boolean isDefaultMinimalPutOverride() {
        return this.region.getSettings().isMinimalPutsEnabled();
    }

    public CollectionRegion getRegion() {
        return this.region;
    }

    public Object generateCacheKey(Object id, CollectionPersister persister, SessionFactoryImplementor factory, String tenantIdentifier) {
        return DefaultCacheKeysFactory.createCollectionKey((Object)id, (CollectionPersister)persister, (SessionFactoryImplementor)factory, (String)tenantIdentifier);
    }

    public Object getCacheKeyId(Object cacheKey) {
        return DefaultCacheKeysFactory.getCollectionId((Object)cacheKey);
    }
}

