/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.cache;

import java.util.Comparator;
import org.hibernate.cache.spi.CollectionRegion;
import org.hibernate.cache.spi.access.CollectionRegionAccessStrategy;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.testing.cache.AbstractReadWriteAccessStrategy;
import org.hibernate.testing.cache.BaseGeneralDataRegion;
import org.hibernate.testing.cache.CollectionRegionImpl;

class ReadWriteCollectionRegionAccessStrategy
extends AbstractReadWriteAccessStrategy
implements CollectionRegionAccessStrategy {
    private final CollectionRegionImpl region;

    ReadWriteCollectionRegionAccessStrategy(CollectionRegionImpl region) {
        this.region = region;
    }

    @Override
    Comparator getVersionComparator() {
        return this.region.getCacheDataDescription().getVersionComparator();
    }

    @Override
    protected BaseGeneralDataRegion getInternalRegion() {
        return this.region;
    }

    @Override
    protected boolean isDefaultMinimalPutOverride() {
        return this.region.getSettings().isMinimalPutsEnabled();
    }

    public CollectionRegion getRegion() {
        return this.region;
    }

    public Object generateCacheKey(Object id, CollectionPersister persister, SessionFactoryImplementor factory, String tenantIdentifier) {
        return this.region.getRegionFactory().getCacheKeysFactory().createCollectionKey(id, persister, factory, tenantIdentifier);
    }

    public Object getCacheKeyId(Object cacheKey) {
        return this.region.getRegionFactory().getCacheKeysFactory().getCollectionId(cacheKey);
    }
}

