/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.byteman;

import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.byteman.rule.Rule;
import org.jboss.byteman.rule.helper.Helper;
import org.jboss.logging.Logger;

public class BytemanHelper
extends Helper {
    private static final Logger log = Logger.getLogger(BytemanHelper.class);
    public static final AtomicInteger counter = new AtomicInteger();

    protected BytemanHelper(Rule rule) {
        super(rule);
    }

    public void sleepASecond() {
        try {
            log.info((Object)"Byteman rule triggered: sleeping a second");
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error((Object)"unexpected interruption", (Throwable)e);
        }
    }

    public void throwNPE(String message) {
        throw new NullPointerException(message);
    }

    public void countInvocation() {
        log.debug((Object)"Increment call count");
        counter.incrementAndGet();
    }

    public static int getAndResetInvocationCount() {
        return counter.getAndSet(0);
    }
}

