/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.junit4;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.List;
import org.hibernate.testing.AfterClassOnce;
import org.hibernate.testing.BeforeClassOnce;
import org.hibernate.testing.OnExpectedFailure;
import org.hibernate.testing.OnFailure;
import org.hibernate.testing.junit4.CallbackException;
import org.hibernate.testing.junit4.Helper;
import org.hibernate.testing.junit4.InvalidMethodForAnnotationException;

public class TestClassMetadata {
    private static final Object[] NO_ARGS = new Object[0];
    private LinkedHashSet<Method> beforeClassOnceMethods;
    private LinkedHashSet<Method> afterClassOnceMethods;
    private LinkedHashSet<Method> onFailureCallbacks;
    private LinkedHashSet<Method> onExpectedFailureCallbacks;

    public TestClassMetadata(Class testClass) {
        this.processClassHierarchy(testClass);
    }

    private void processClassHierarchy(Class testClass) {
        for (Method method : testClass.getDeclaredMethods()) {
            if (method.getAnnotation(CallbackType.BEFORE_CLASS_ONCE.annotationClass) != null) {
                this.addBeforeClassOnceCallback(method);
            }
            if (method.getAnnotation(CallbackType.AFTER_CLASS_ONCE.annotationClass) != null) {
                this.addAfterClassOnceCallback(method);
            }
            if (method.getAnnotation(CallbackType.ON_FAILURE.annotationClass) != null) {
                this.addOnFailureCallback(method);
            }
            if (method.getAnnotation(CallbackType.ON_EXPECTED_FAILURE.annotationClass) == null) continue;
            this.addOnExpectedFailureCallback(method);
        }
        Class superClass = testClass.getSuperclass();
        if (superClass != null) {
            this.processClassHierarchy(superClass);
        }
    }

    private void addBeforeClassOnceCallback(Method method) {
        if (this.beforeClassOnceMethods == null) {
            this.beforeClassOnceMethods = new LinkedHashSet();
        }
        this.ensureAccessibility(method);
        this.beforeClassOnceMethods.add(method);
    }

    private void ensureAccessibility(Method method) {
        if (!method.isAccessible()) {
            try {
                method.setAccessible(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void addAfterClassOnceCallback(Method method) {
        if (this.afterClassOnceMethods == null) {
            this.afterClassOnceMethods = new LinkedHashSet();
        }
        this.ensureAccessibility(method);
        this.afterClassOnceMethods.add(method);
    }

    private void addOnFailureCallback(Method method) {
        if (this.onFailureCallbacks == null) {
            this.onFailureCallbacks = new LinkedHashSet();
        }
        this.ensureAccessibility(method);
        this.onFailureCallbacks.add(method);
    }

    private void addOnExpectedFailureCallback(Method method) {
        if (this.onExpectedFailureCallbacks == null) {
            this.onExpectedFailureCallbacks = new LinkedHashSet();
        }
        this.ensureAccessibility(method);
        this.onExpectedFailureCallbacks.add(method);
    }

    public void validate(List<Throwable> errors) {
        this.validate(this.beforeClassOnceMethods, CallbackType.BEFORE_CLASS_ONCE, errors);
        this.validate(this.afterClassOnceMethods, CallbackType.AFTER_CLASS_ONCE, errors);
        this.validate(this.onFailureCallbacks, CallbackType.ON_FAILURE, errors);
        this.validate(this.onExpectedFailureCallbacks, CallbackType.ON_EXPECTED_FAILURE, errors);
    }

    private void validate(LinkedHashSet<Method> callbackMethods, CallbackType callbackType, List<Throwable> errors) {
        if (callbackMethods != null) {
            for (Method method : callbackMethods) {
                this.validateCallbackMethod(method, callbackType, errors);
            }
        }
    }

    private void validateCallbackMethod(Method method, CallbackType type, List<Throwable> errors) {
        if (method.getParameterTypes().length > 0) {
            errors.add(new InvalidMethodForAnnotationException(type.buildTypeMarker() + " callback only valid on no-arg methods : " + Helper.extractMethodName(method)));
        }
        if (!method.isAccessible()) {
            try {
                method.setAccessible(true);
            }
            catch (Exception e) {
                errors.add(new InvalidMethodForAnnotationException(type.buildTypeMarker() + " attached to inaccessible method and unable to make accessible"));
            }
        }
    }

    public void performBeforeClassCallbacks(Object target) {
        this.performCallbacks(this.beforeClassOnceMethods, target);
    }

    private void performCallbacks(LinkedHashSet<Method> callbackMethods, Object target) {
        if (callbackMethods == null) {
            return;
        }
        for (Method callbackMethod : callbackMethods) {
            this.invokeCallback(callbackMethod, target);
        }
    }

    private void invokeCallback(Method callback, Object target) {
        try {
            callback.invoke(target, NO_ARGS);
        }
        catch (InvocationTargetException e) {
            throw new CallbackException(callback, e.getTargetException());
        }
        catch (IllegalAccessException e) {
            throw new CallbackException(callback, (Throwable)e);
        }
    }

    public void performAfterClassCallbacks(Object target) {
        this.performCallbacks(this.afterClassOnceMethods, target);
    }

    public void performOnFailureCallback(Object target) {
        this.performCallbacks(this.onFailureCallbacks, target);
    }

    public void performOnExpectedFailureCallback(Object target) {
        this.performCallbacks(this.onExpectedFailureCallbacks, target);
    }

    private static enum CallbackType {
        BEFORE_CLASS_ONCE(BeforeClassOnce.class),
        AFTER_CLASS_ONCE(AfterClassOnce.class),
        ON_FAILURE(OnFailure.class),
        ON_EXPECTED_FAILURE(OnExpectedFailure.class);

        private final Class<? extends Annotation> annotationClass;

        private CallbackType(Class<? extends Annotation> annotationClass) {
            this.annotationClass = annotationClass;
        }

        public Class<? extends Annotation> getAnnotationClass() {
            return this.annotationClass;
        }

        public String buildTypeMarker() {
            return "@" + this.getAnnotationClass().getSimpleName();
        }
    }
}

