/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.junit;

import java.util.Enumeration;
import junit.framework.Test;
import junit.framework.TestSuite;

public class TestSuiteVisitor {
    private final Handler handler;

    public TestSuiteVisitor(Handler handler) {
        this.handler = handler;
    }

    public void visit(TestSuite testSuite) {
        this.handler.startingTestSuite(testSuite);
        Enumeration tests = testSuite.tests();
        while (tests.hasMoreElements()) {
            Test test = (Test)tests.nextElement();
            if (test instanceof TestSuite) {
                this.visit((TestSuite)test);
                continue;
            }
            this.handler.handleTestCase(test);
        }
        this.handler.completedTestSuite(testSuite);
    }

    public static interface Handler {
        public void handleTestCase(Test var1);

        public void startingTestSuite(TestSuite var1);

        public void completedTestSuite(TestSuite var1);
    }
}

