/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.oracle;

import java.util.List;
import org.hibernate.QueryException;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.spatial.SpatialFunction;
import org.hibernate.spatial.dialect.SpatialFunctionsRegistry;
import org.hibernate.spatial.dialect.oracle.GetDimensionFunction;
import org.hibernate.spatial.dialect.oracle.GetGeometryTypeFunction;
import org.hibernate.spatial.dialect.oracle.OracleSDOSupport;
import org.hibernate.spatial.dialect.oracle.SDOObjectProperty;
import org.hibernate.spatial.dialect.oracle.WrappedOGCFunction;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

class OracleSpatialFunctions
extends SpatialFunctionsRegistry {
    OracleSpatialFunctions(boolean strictOgc, OracleSDOSupport sdoSupport) {
        this.put("dimension", new GetDimensionFunction());
        this.put("geometrytype", new GetGeometryTypeFunction());
        this.put("srid", new SDOObjectProperty("SDO_SRID", (Type)StandardBasicTypes.INTEGER));
        this.put("envelope", (SQLFunction)new StandardSQLFunction("SDO_GEOM.SDO_MBR"));
        this.put("astext", (SQLFunction)new AsTextFunction());
        this.put("asbinary", (SQLFunction)new StandardSQLFunction("SDO_UTIL.TO_WKBGEOMETRY", (Type)StandardBasicTypes.BINARY));
        this.put("isempty", (SQLFunction)new WrappedOGCFunction("OGC_ISEMPTY", (Type)StandardBasicTypes.BOOLEAN, new boolean[]{true}));
        this.put("issimple", (SQLFunction)new WrappedOGCFunction("OGC_ISSIMPLE", (Type)StandardBasicTypes.BOOLEAN, new boolean[]{true}));
        this.put("boundary", (SQLFunction)new WrappedOGCFunction("OGC_BOUNDARY", new boolean[]{true}));
        this.put("overlaps", (SQLFunction)new SpatialRelateFunction("overlaps", 5, strictOgc, sdoSupport));
        this.put("intersects", (SQLFunction)new SpatialRelateFunction("intersects", 7, strictOgc, sdoSupport));
        this.put("contains", (SQLFunction)new SpatialRelateFunction("contains", 6, strictOgc, sdoSupport));
        this.put("crosses", (SQLFunction)new SpatialRelateFunction("crosses", 3, strictOgc, sdoSupport));
        this.put("disjoint", (SQLFunction)new SpatialRelateFunction("disjoint", 1, strictOgc, sdoSupport));
        this.put("equals", (SQLFunction)new SpatialRelateFunction("equals", 0, strictOgc, sdoSupport));
        this.put("touches", (SQLFunction)new SpatialRelateFunction("touches", 2, strictOgc, sdoSupport));
        this.put("within", (SQLFunction)new SpatialRelateFunction("within", 4, strictOgc, sdoSupport));
        this.put("relate", (SQLFunction)new WrappedOGCFunction("OGC_RELATE", (Type)StandardBasicTypes.BOOLEAN, new boolean[]{true, true, false}));
        this.put("distance", (SQLFunction)new SpatialAnalysisFunction("distance", (Type)StandardBasicTypes.DOUBLE, 1, strictOgc));
        this.put("buffer", (SQLFunction)new SpatialAnalysisFunction("buffer", 2, strictOgc));
        this.put("convexhull", (SQLFunction)new SpatialAnalysisFunction("convexhull", 3, strictOgc));
        this.put("difference", (SQLFunction)new SpatialAnalysisFunction("difference", 6, strictOgc));
        this.put("intersection", (SQLFunction)new SpatialAnalysisFunction("intersection", 4, strictOgc));
        this.put("symdifference", (SQLFunction)new SpatialAnalysisFunction("symdifference", 7, strictOgc));
        this.put("geomunion", (SQLFunction)new SpatialAnalysisFunction("union", 5, strictOgc));
        this.put("extent", (SQLFunction)new SpatialAggregationFunction("extent", 1, sdoSupport));
        this.put(SpatialFunction.filter.name(), (SQLFunction)new StandardSQLFunction("SDO_FILTER"));
        this.put("transform", (SQLFunction)new StandardSQLFunction("SDO_CS.TRANSFORM"));
        this.put("centroid", (SQLFunction)new SpatialAggregationFunction("extent", 101, sdoSupport));
        this.put("concat_lines", (SQLFunction)new SpatialAggregationFunction("extent", 102, sdoSupport));
        this.put("aggr_convexhull", (SQLFunction)new SpatialAggregationFunction("extent", 104, sdoSupport));
        this.put("aggr_union", (SQLFunction)new SpatialAggregationFunction("extent", 103, sdoSupport));
        this.put("lrs_concat", (SQLFunction)new SpatialAggregationFunction("lrsconcat", 100, sdoSupport));
    }

    static String getOGCSpatialAnalysisSQL(List args, int spatialAnalysisFunction) {
        boolean[] geomArgs;
        StringBuilder ogcFunction = new StringBuilder("MDSYS.");
        boolean isGeomReturn = true;
        switch (spatialAnalysisFunction) {
            case 2: {
                ogcFunction.append("OGC_BUFFER");
                geomArgs = new boolean[]{true, false};
                break;
            }
            case 3: {
                ogcFunction.append("OGC_CONVEXHULL");
                geomArgs = new boolean[]{true};
                break;
            }
            case 6: {
                ogcFunction.append("OGC_DIFFERENCE");
                geomArgs = new boolean[]{true, true};
                break;
            }
            case 1: {
                ogcFunction.append("OGC_DISTANCE");
                geomArgs = new boolean[]{true, true};
                isGeomReturn = false;
                break;
            }
            case 4: {
                ogcFunction.append("OGC_INTERSECTION");
                geomArgs = new boolean[]{true, true};
                break;
            }
            case 7: {
                ogcFunction.append("OGC_SYMMETRICDIFFERENCE");
                geomArgs = new boolean[]{true, true};
                break;
            }
            case 5: {
                ogcFunction.append("OGC_UNION");
                geomArgs = new boolean[]{true, true};
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown SpatialAnalysisFunction (" + spatialAnalysisFunction + ").");
            }
        }
        if (args.size() < geomArgs.length) {
            throw new QueryException("Insufficient arguments for spatial analysis function (function type:  " + spatialAnalysisFunction + ").");
        }
        ogcFunction.append("(");
        for (int i = 0; i < geomArgs.length; ++i) {
            if (i > 0) {
                ogcFunction.append(",");
            }
            if (geomArgs[i]) {
                OracleSpatialFunctions.wrapInSTGeometry((String)args.get(i), ogcFunction);
                continue;
            }
            ogcFunction.append(args.get(i));
        }
        ogcFunction.append(")");
        if (isGeomReturn) {
            ogcFunction.append(".geom");
        }
        return ogcFunction.toString();
    }

    private static StringBuilder wrapInSTGeometry(String geomColumn, StringBuilder toAdd) {
        return toAdd.append("MDSYS.ST_GEOMETRY(").append(geomColumn).append(")");
    }

    static String getNativeSpatialAnalysisSQL(List args, int spatialAnalysis) {
        return OracleSpatialFunctions.getOGCSpatialAnalysisSQL(args, spatialAnalysis);
    }

    static String getSpatialAnalysisSQL(List args, int spatialAnalysisFunction) {
        return OracleSpatialFunctions.getOGCSpatialAnalysisSQL(args, spatialAnalysisFunction);
    }

    static class SpatialAggregationFunction
    extends StandardSQLFunction {
        private final int aggregation;
        private final OracleSDOSupport sdo;

        private SpatialAggregationFunction(String name, int aggregation, OracleSDOSupport dialect) {
            super(name);
            this.aggregation = aggregation;
            this.sdo = dialect;
        }

        public String render(Type firstArgumentType, List args, SessionFactoryImplementor factory) {
            return this.sdo.getSpatialAggregateSQL((String)args.get(0), this.aggregation);
        }
    }

    private static class SpatialAnalysisFunction
    extends StandardSQLFunction {
        private final int analysis;
        private final boolean isOGCStrict;

        private SpatialAnalysisFunction(String name, Type returnType, int analysis, boolean isOGCStrict) {
            super(name, returnType);
            this.analysis = analysis;
            this.isOGCStrict = isOGCStrict;
        }

        private SpatialAnalysisFunction(String name, int analysis, boolean isOGCStrict) {
            this(name, null, analysis, isOGCStrict);
        }

        public String render(Type firstArgumentType, List args, SessionFactoryImplementor factory) {
            return this.isOGCStrict ? OracleSpatialFunctions.getSpatialAnalysisSQL(args, this.analysis) : OracleSpatialFunctions.getNativeSpatialAnalysisSQL(args, this.analysis);
        }
    }

    private static class SpatialRelateFunction
    extends StandardSQLFunction {
        private final int relation;
        private final boolean isOGCStrict;
        private OracleSDOSupport sdo;

        private SpatialRelateFunction(String name, int relation, boolean isOGCStrict, OracleSDOSupport sdo) {
            super(name, (Type)StandardBasicTypes.BOOLEAN);
            this.relation = relation;
            this.isOGCStrict = isOGCStrict;
            this.sdo = sdo;
        }

        public String render(Type firstArgumentType, List args, SessionFactoryImplementor factory) {
            if (args.size() < 2) {
                throw new QueryException("Spatial relate functions require at least two arguments");
            }
            return this.isOGCStrict ? this.sdo.getOGCSpatialRelateSQL((String)args.get(0), (String)args.get(1), this.relation) : this.sdo.getNativeSpatialRelateSQL((String)args.get(0), (String)args.get(1), this.relation);
        }
    }

    private static class AsTextFunction
    extends StandardSQLFunction {
        private AsTextFunction() {
            super("astext", (Type)StandardBasicTypes.STRING);
        }

        public String render(Type firstArgumentType, List args, SessionFactoryImplementor factory) {
            StringBuilder buf = new StringBuilder();
            if (args.isEmpty()) {
                throw new IllegalArgumentException("First Argument in arglist must be object to which method is applied");
            }
            buf.append("TO_CHAR(SDO_UTIL.TO_WKTGEOMETRY(").append(args.get(0)).append("))");
            return buf.toString();
        }
    }
}

