/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.postgis;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.geolatte.geom.ByteBuffer;
import org.geolatte.geom.ByteOrder;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.codec.Wkb;
import org.geolatte.geom.codec.WkbDecoder;
import org.geolatte.geom.codec.WkbEncoder;
import org.geolatte.geom.codec.Wkt;
import org.geolatte.geom.codec.WktDecoder;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.BasicBinder;
import org.hibernate.type.descriptor.sql.BasicExtractor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;
import org.postgresql.util.PGobject;

public class PGGeometryTypeDescriptor
implements SqlTypeDescriptor {
    public static final PGGeometryTypeDescriptor INSTANCE = new PGGeometryTypeDescriptor();

    public int getSqlType() {
        return 1111;
    }

    public boolean canBeRemapped() {
        return false;
    }

    public <X> ValueBinder<X> getBinder(JavaTypeDescriptor<X> javaTypeDescriptor) {
        return new BasicBinder<X>(javaTypeDescriptor, this){

            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                WkbEncoder encoder = Wkb.newEncoder((Wkb.Dialect)Wkb.Dialect.POSTGIS_EWKB_1);
                Geometry geometry = (Geometry)this.getJavaDescriptor().unwrap(value, Geometry.class, options);
                byte[] bytes = encoder.encode(geometry, ByteOrder.NDR).toByteArray();
                st.setBytes(index, bytes);
            }
        };
    }

    public <X> ValueExtractor<X> getExtractor(JavaTypeDescriptor<X> javaTypeDescriptor) {
        return new BasicExtractor<X>(javaTypeDescriptor, this){

            protected X doExtract(ResultSet rs, String name, WrapperOptions options) throws SQLException {
                return this.getJavaDescriptor().wrap((Object)PGGeometryTypeDescriptor.toGeometry(rs.getObject(name)), options);
            }

            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return this.getJavaDescriptor().wrap((Object)PGGeometryTypeDescriptor.toGeometry(statement.getObject(index)), options);
            }

            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return this.getJavaDescriptor().wrap((Object)PGGeometryTypeDescriptor.toGeometry(statement.getObject(name)), options);
            }
        };
    }

    public static Geometry toGeometry(Object object) {
        if (object == null) {
            return null;
        }
        ByteBuffer buffer = null;
        if (object instanceof PGobject) {
            String pgValue = ((PGobject)object).getValue();
            if (pgValue.charAt(0) == 'S') {
                WktDecoder decoder = Wkt.newDecoder((Wkt.Dialect)Wkt.Dialect.POSTGIS_EWKT_1);
                return decoder.decode(pgValue);
            }
            buffer = ByteBuffer.from((String)pgValue);
            WkbDecoder decoder = Wkb.newDecoder((Wkb.Dialect)Wkb.Dialect.POSTGIS_EWKB_1);
            return decoder.decode(buffer);
        }
        throw new IllegalStateException("Received object of type " + object.getClass().getCanonicalName());
    }
}

