/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.hibernate.impl;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.hibernate.search.query.engine.spi.TimeoutManager;
import org.hibernate.search.query.hibernate.impl.Loader;
import org.hibernate.search.query.hibernate.impl.ObjectLoaderBuilder;
import org.hibernate.search.query.hibernate.impl.ObjectsInitializer;
import org.hibernate.transform.ResultTransformer;

public class ProjectionLoader
implements Loader {
    private Loader objectLoader;
    private Boolean projectThis;
    private ResultTransformer transformer;
    private String[] aliases;
    private ObjectLoaderBuilder loaderBuilder;

    @Override
    public void init(Session session, SearchFactoryImplementor searchFactoryImplementor, ObjectsInitializer objectsInitializer, TimeoutManager timeoutManager) {
    }

    public void init(Session session, SearchFactoryImplementor searchFactoryImplementor, ResultTransformer transformer, ObjectLoaderBuilder loaderBuilder, String[] aliases, TimeoutManager timeoutManager) {
        this.init(session, searchFactoryImplementor, null, timeoutManager);
        this.transformer = transformer;
        this.aliases = aliases;
        this.loaderBuilder = loaderBuilder;
    }

    @Override
    public Object load(EntityInfo entityInfo) {
        this.initThisProjectionFlag(entityInfo);
        if (this.projectThis.booleanValue()) {
            Loader objectLoader = this.getObjectLoader();
            Object entityInstance = objectLoader.load(entityInfo);
            entityInfo.populateWithEntityInstance(entityInstance);
        }
        if (this.transformer != null) {
            return this.transformer.transformTuple(entityInfo.getProjection(), this.aliases);
        }
        return entityInfo.getProjection();
    }

    @Override
    public Object loadWithoutTiming(EntityInfo entityInfo) {
        throw new AssertionFailure("This method is not meant to be used on ProjectionLoader");
    }

    private void initThisProjectionFlag(EntityInfo entityInfo) {
        if (this.projectThis == null) {
            this.projectThis = entityInfo.isProjectThis();
        }
    }

    @Override
    public List load(EntityInfo ... entityInfos) {
        ArrayList<Object> results = new ArrayList<Object>(entityInfos.length);
        if (entityInfos.length == 0) {
            return results;
        }
        this.initThisProjectionFlag(entityInfos[0]);
        if (this.projectThis.booleanValue()) {
            Loader objectLoader = this.getObjectLoader();
            objectLoader.load(entityInfos);
            for (EntityInfo entityInfo : entityInfos) {
                Object entityInstance = objectLoader.loadWithoutTiming(entityInfo);
                entityInfo.populateWithEntityInstance(entityInstance);
            }
        }
        for (EntityInfo entityInfo : entityInfos) {
            if (this.transformer != null) {
                results.add(this.transformer.transformTuple(entityInfo.getProjection(), this.aliases));
                continue;
            }
            results.add(entityInfo.getProjection());
        }
        return results;
    }

    private Loader getObjectLoader() {
        if (this.objectLoader == null) {
            this.objectLoader = this.loaderBuilder.buildLoader();
        }
        return this.objectLoader;
    }

    @Override
    public boolean isSizeSafe() {
        return this.getObjectLoader().isSizeSafe();
    }
}

