/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene.works;

import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.hibernate.search.SearchException;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.impl.lucene.works.LuceneWorkDelegate;
import org.hibernate.search.batchindexing.MassIndexerProgressMonitor;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

class PurgeAllWorkDelegate
implements LuceneWorkDelegate {
    private static final Log log = LoggerFactory.make();

    PurgeAllWorkDelegate() {
    }

    @Override
    public void performWork(LuceneWork work, IndexWriter writer) {
        Class<?> entityType = work.getEntityClass();
        log.tracef("purgeAll Lucene index using IndexWriter for type: %s", entityType);
        try {
            Term term = new Term("_hibernate_class", entityType.getName());
            writer.deleteDocuments(term);
        }
        catch (Exception e) {
            throw new SearchException("Unable to purge all from Lucene index: " + entityType, e);
        }
    }

    @Override
    public void logWorkDone(LuceneWork work, MassIndexerProgressMonitor monitor) {
    }
}

