/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.jgroups;

import java.util.List;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.impl.jgroups.JGroupsBackendQueueProcessor;
import org.hibernate.search.backend.impl.jgroups.JGroupsMasterMessageListener;
import org.hibernate.search.backend.impl.lucene.LuceneBackendQueueProcessor;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.indexes.impl.DirectoryBasedIndexManager;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;
import org.jgroups.Receiver;

public class MasterJGroupsBackendQueueProcessor
extends JGroupsBackendQueueProcessor {
    private static final Log log = LoggerFactory.make();
    private LuceneBackendQueueProcessor luceneBackendQueueProcessor;
    private Receiver masterListener;

    @Override
    public void initialize(Properties props, WorkerBuildContext context, DirectoryBasedIndexManager indexManager) {
        super.initialize(props, context, indexManager);
        this.initLuceneBackendQueueProcessor(props, context);
        this.registerMasterListener(context.getUninitializedSearchFactory());
    }

    private void registerMasterListener(SearchFactoryImplementor searchFactory) {
        this.masterListener = new JGroupsMasterMessageListener(searchFactory);
        this.channel.setReceiver(this.masterListener);
    }

    private void initLuceneBackendQueueProcessor(Properties props, WorkerBuildContext context) {
        this.luceneBackendQueueProcessor = new LuceneBackendQueueProcessor();
        this.luceneBackendQueueProcessor.initialize(props, context, this.indexManager);
    }

    public Receiver getMasterListener() {
        return this.masterListener;
    }

    @Override
    public void close() {
        super.close();
        this.luceneBackendQueueProcessor.close();
    }

    @Override
    public void applyWork(List<LuceneWork> workList) {
        this.luceneBackendQueueProcessor.applyWork(workList);
    }

    @Override
    public void applyStreamWork(LuceneWork singleOperation) {
        this.luceneBackendQueueProcessor.applyStreamWork(singleOperation);
    }

    @Override
    public Lock getExclusiveWriteLock() {
        log.warnSuspiciousBackendDirectoryCombination(this.indexName);
        return new ReentrantLock();
    }
}

