/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.logging.impl;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.lucene.index.CorruptIndexException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Cause;
import org.jboss.logging.LogMessage;
import org.jboss.logging.Logger;
import org.jboss.logging.Message;
import org.jboss.logging.MessageLogger;

@MessageLogger(projectCode="HSEARCH")
public interface Log
extends BasicLogger {
    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1, value="initialized \"blackhole\" backend. Index changes will be prepared but discarded!")
    public void initializedBlackholeBackend();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=2, value="closed \"blackhole\" backend.")
    public void closedBlackholeBackend();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=3, value="update DirectoryProviders \"blackhole\" backend. Index changes will be prepared but discarded!")
    public void updatedDirectoryProviders();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=4, value="Exception attempting to instantiate Similarity '%1$s' set for %2$s")
    public void similarityInstantiationException(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=5, value="Starting JGroups Channel")
    public void jGroupsStartingChannel();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=6, value="Connected to cluster [ %1$s ]. The node address is %2$s")
    public void jGroupsConnectedToCluster(String var1, Object var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=7, value="FLUSH is not present in your JGroups stack!  FLUSH is needed to ensure messages are not dropped while new nodes join the cluster.  Will proceed, but inconsistencies may arise!")
    public void jGroupsFlushNotPresentInStack();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=8, value="Error while trying to create a channel using config files: %s")
    public void jGroupsChannelCreationUsingFileError(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=9, value="Error while trying to create a channel using config XML: %s")
    public void jGroupsChannelCreationUsingXmlError(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=10, value="Error while trying to create a channel using config string: %s")
    public void jGroupsChannelCreationFromStringError(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=11, value="Unable to use any JGroups configuration mechanisms provided in properties %s. Using default JGroups configuration file!")
    public void jGroupsConfigurationNotFoundInProperties(Properties var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=12, value="Default JGroups configuration file was not found. Attempt to start JGroups channel with default configuration!")
    public void jGroupsDefaultConfigurationFileNotFound();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=13, value="Disconnecting and closing JGroups Channel")
    public void jGroupsDisconnectingAndClosingChannel();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=14, value="Problem closing channel; setting it to null")
    public void jGroupsClosingChannelError(@Cause Exception var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=15, value="Received new cluster view: %s")
    public void jGroupsReceivedNewClusterView(Object var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=16, value="Incorrect message type: %s")
    public void incorrectMessageType(Class<?> var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=17, value="Work discarded, thread was interrupted while waiting for space to schedule: %s")
    public void interruptedWorkError(Runnable var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=18, value="Skipping directory synchronization, previous work still in progress: %s")
    public void skippingDirectorySynchronization(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=19, value="Unable to remove previous marker file from source of %s")
    public void unableToRemovePreviousMarket(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=20, value="Unable to create current marker in source of %s")
    public void unableToCreateCurrentMarker(String var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=21, value="Unable to synchronize source of %s")
    public void unableToSynchronizeSource(String var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=22, value="Unable to determine current in source directory, will try again during the next synchronization")
    public void unableToDetermineCurrentInSourceDirectory();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=23, value="Unable to compare %1$s with %2$s.")
    public void unableToCompareSourceWithDestinationDirectory(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=24, value="Unable to reindex entity on collection change, id cannot be extracted: %s")
    public void idCannotBeExtracted(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=25, value="Service provider has been used but not released: %s")
    public void serviceProviderNotReleased(Class<?> var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=26, value="Fail to properly stop service: %s")
    public void stopServiceFailed(Class<?> var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=27, value="Going to reindex %d entities")
    public void indexingEntities(long var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=28, value="Reindexed %d entities")
    public void indexingEntitiesCompleted(long var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=29, value="Indexing completed. Reindexed %d entities. Unregistering MBean from server")
    public void indexingCompletedAndMBeanUnregistered(long var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=30, value="%1$d documents indexed in %2$d ms")
    public void indexingDocumentsCompleted(long var1, long var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=31, value="Indexing speed: %1$f documents/second; progress: %2$f%%")
    public void indexingSpeed(float var1, float var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=32, value="Could not delete %s")
    public void notDeleted(File var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=33, value="Could not change timestamp for %s. Index synchronization may be slow.")
    public void notChangeTimestamp(File var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=34, value="Hibernate Search %s")
    public void version(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=35, value="could not close resource: ")
    public void couldNotCloseResource(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=36, value="Cannot guess the Transaction Status: not starting a JTA transaction")
    public void cannotGuessTransactionStatus(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=37, value="Unable to properly close searcher during lucene query: %s")
    public void unableToCloseSearcherDuringQuery(String var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=38, value="Forced to use Document extraction to workaround FieldCache bug in Lucene")
    public void forceToUseDocumentExtraction();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=39, value="Unable to properly close searcher in ScrollableResults")
    public void unableToCloseSearcherInScrollableResult(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=40, value="Unexpected: value is missing from FieldCache. This is likely a bug in the FieldCache implementation, Hibernate Search might have to workaround this by slightly inaccurate faceting values or reduced performance.")
    public void unexpectedValueMissingFromFieldCache();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=41, value="Index directory not found, creating: '%s'")
    public void indexDirectoryNotFoundCreatingNewOne(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=42, value="No current marker in source directory. Has the master being started already?")
    public void noCurrentMarkerInSourceDirectory();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=43, value="Found current marker in source directory - initialization succeeded")
    public void foundCurrentMarker();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=44, value="Abstract classes can never insert index documents. Remove @Indexed.")
    public void abstractClassesCannotInsertDocuments();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=45, value="@ContainedIn is pointing to an entity having @ProvidedId. This is not supported, indexing of contained in entities will be skipped. Indexed data of the embedded object might become out of date in objects of type ")
    public void containedInPointsToProvidedId(Class<?> var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=46, value="FieldCache was enabled on class %s but for this type of identifier we can't extract values from the FieldCache: cache disabled")
    public void cannotExtractValueForIdentifier(Class<?> var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=47, value="Unable to close JMS connection for %s")
    public void unableToCloseJmsConnection(String var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=48, value="Unable to retrieve named analyzer: %s")
    public void unableToRetrieveNamedAnalyzer(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=49, value="Was interrupted while waiting for index activity to finish. Index might be inconsistent or have a stale lock")
    public void interruptedWhileWaitingForIndexActivity();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=50, value="It appears changes are being pushed to the index out of a transaction. Register the IndexWorkFlushEventListener listener on flush to correctly manage Collections!")
    public void pushedChangesOutOfTransaction();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=51, value="Received null or empty Lucene works list in message.")
    public void receivedEmptyLuceneWOrksInMessage();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=52, value="Going to force release of the IndexWriter lock")
    public void forcingReleaseIndexWriterLock();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=53, value="Chunk size must be positive: using default value.")
    public void checkSizeMustBePositive();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=54, value="ReaderProvider contains readers not properly closed at destroy time")
    public void readersNotProperlyClosedinReaderProvider();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=55, value="Unable to close Lucene IndexReader")
    public void unableToCLoseLuceneIndexReader(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=56, value="Unable to un-register existing MBean: ")
    public void unableToUnregisterExistingMBean(String var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=57, value="Property hibernate.search.autoregister_listeners is set to false. No attempt will be made to register Hibernate Search event listeners.")
    public void eventListenerWontBeRegistered();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=58, value="%s")
    public void exceptionOccured(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=59, value="Worker raises an exception on close()")
    public void workerException(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=60, value="ReaderProvider raises an exception on destroy()")
    public void readerProviderExceptionOnDestroy(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=61, value="DirectoryProvider raises an exception on stop() ")
    public void directoryProviderExceptionOnStop(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=62, value="Batch indexing was interrupted")
    public void interruptedBatchIndexig();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=63, value="Error during batch indexing: ")
    public void errorDuringBatchIndexing(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=64, value="Error while executing runnable wrapped in a JTA transaction")
    public void errorExecutingRunnableInTransaction(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=65, value="Error while rollbacking transaction after %s")
    public void errorRollbackingTransaction(String var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=66, value="Failed to initialize SlaveDirectoryProvider %s")
    public void failedSlaveDirectoryProviderInitialization(String var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=67, value="Unable to properly close Lucene directory %s")
    public void unableToCloseLuceneDirectory(Object var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=68, value="Unable to retrieve object from message: %s")
    public void unableToRetrieveObjectFromMessage(Class<?> var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=69, value="Illegal object retrieved from message")
    public void illegalObjectRetrievedFromMessage(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=70, value="Terminating batch work! Index might end up in inconsistent state.")
    public void terminatingBatchWorkCanCauseInconsistentState();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=71, value="Unable to properly shut down asynchronous indexing work")
    public void unableToShutdownAsyncronousIndexing(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=72, value="Couldn't open the IndexWriter because of previous error: operation skipped, index ouf of sync!")
    public void cannotOpenIndexWriterCausePreviousError();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=73, value="Error in backend")
    public void backendError(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=74, value="Unexpected error in Lucene Backend:")
    public void unexpectedErrorInLuceneBackend(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=75, value="Configuration setting hibernate.search.lucene_version was not specified, using LUCENE_CURRENT.")
    public void recommendConfiguringLuceneVersion();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=76, value="Could not open Lucene index: data is corrupted. index name: \"%s\"")
    public void cantOpenCorruptedIndex(@Cause CorruptIndexException var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=77, value="An IOException happened while accessing the Lucene index")
    public void ioExceptionOnIndex(@Cause IOException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=78, value="Timed out waiting to flush all operations to the backend of index %s")
    public void unableToShutdownAsyncronousIndexingByTimeout(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=79, value="Serialization protocol version %1$d.%2$d")
    public void serializationProtocol(int var1, int var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=80, value="Received a remote message about an unknown index '%s': discarding message!")
    public void messageReceivedForUndefinedIndex(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=81, value="The index '%s' is using a non-recommended combination of backend and directoryProvider implementations")
    public void warnSuspiciousBackendDirectoryCombination(String var1);
}

