/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.indexes.serialization.codex.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import org.hibernate.search.SearchException;

public class SerializationHelper {
    public static byte[] toByteArray(Serializable instance) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ObjectOutputStream stream = new ObjectOutputStream(out);
            stream.writeObject(instance);
            stream.close();
        }
        catch (IOException e) {
            throw new SearchException("Unable to serialize object: " + instance.getClass(), e);
        }
        return out.toByteArray();
    }

    public static <T> T toInstance(byte[] data, Class<T> clazz) {
        try {
            ByteArrayInputStream byteIn = new ByteArrayInputStream(data);
            ClassLoaderAwareObjectInputStream in = new ClassLoaderAwareObjectInputStream(byteIn, clazz.getClassLoader());
            return (T)in.readObject();
        }
        catch (IOException e) {
            throw new SearchException("Unable to deserialize object", e);
        }
        catch (ClassNotFoundException e) {
            throw new SearchException("Unable to deserialize object", e);
        }
    }

    public static Serializable toSerializable(byte[] data, ClassLoader loader) {
        try {
            ByteArrayInputStream byteIn = new ByteArrayInputStream(data);
            ClassLoaderAwareObjectInputStream in = new ClassLoaderAwareObjectInputStream(byteIn, loader);
            return (Serializable)in.readObject();
        }
        catch (IOException e) {
            throw new SearchException("Unable to deserialize object", e);
        }
        catch (ClassNotFoundException e) {
            throw new SearchException("Unable to deserialize object", e);
        }
    }

    private static class ClassLoaderAwareObjectInputStream
    extends ObjectInputStream {
        private ClassLoader classLoader;

        public ClassLoaderAwareObjectInputStream(InputStream in, ClassLoader classLoader) throws IOException {
            super(in);
            this.classLoader = classLoader;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            try {
                Class<?> clazz = Class.forName(desc.getName(), false, this.classLoader);
                return clazz;
            }
            catch (ClassNotFoundException ex) {
                return super.resolveClass(desc);
            }
        }
    }
}

