/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.indexes.serialization.codex.impl;

import java.io.ByteArrayInputStream;
import org.hibernate.search.SearchException;
import org.hibernate.search.indexes.serialization.codex.avro.impl.AvroSerializationProvider;
import org.hibernate.search.indexes.serialization.codex.impl.SerializationHelper;
import org.hibernate.search.indexes.serialization.codex.spi.Deserializer;
import org.hibernate.search.indexes.serialization.codex.spi.LuceneWorksBuilder;
import org.hibernate.search.indexes.serialization.operations.impl.Add;
import org.hibernate.search.indexes.serialization.operations.impl.Delete;
import org.hibernate.search.indexes.serialization.operations.impl.Message;
import org.hibernate.search.indexes.serialization.operations.impl.Operation;
import org.hibernate.search.indexes.serialization.operations.impl.OptimizeAll;
import org.hibernate.search.indexes.serialization.operations.impl.PurgeAll;
import org.hibernate.search.indexes.serialization.operations.impl.SerializableBinaryField;
import org.hibernate.search.indexes.serialization.operations.impl.SerializableCustomFieldable;
import org.hibernate.search.indexes.serialization.operations.impl.SerializableDocument;
import org.hibernate.search.indexes.serialization.operations.impl.SerializableDoubleField;
import org.hibernate.search.indexes.serialization.operations.impl.SerializableField;
import org.hibernate.search.indexes.serialization.operations.impl.SerializableFieldable;
import org.hibernate.search.indexes.serialization.operations.impl.SerializableFloatField;
import org.hibernate.search.indexes.serialization.operations.impl.SerializableIntField;
import org.hibernate.search.indexes.serialization.operations.impl.SerializableLongField;
import org.hibernate.search.indexes.serialization.operations.impl.SerializableNumericField;
import org.hibernate.search.indexes.serialization.operations.impl.SerializableReaderField;
import org.hibernate.search.indexes.serialization.operations.impl.SerializableStringField;
import org.hibernate.search.indexes.serialization.operations.impl.SerializableTokenStreamField;
import org.hibernate.search.indexes.serialization.operations.impl.Update;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class ModelDeserializer
implements Deserializer {
    private static final Log log = LoggerFactory.make();

    @Override
    public void deserialize(byte[] data, LuceneWorksBuilder hydrator) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
        int majorVersion = inputStream.read();
        int minorVersion = inputStream.read();
        if (AvroSerializationProvider.getMajorVersion() != majorVersion) {
            throw new SearchException("Unable to parse message from protocol version " + majorVersion + "." + minorVersion + ". Current protocol version: " + AvroSerializationProvider.getMajorVersion() + "." + AvroSerializationProvider.getMinorVersion());
        }
        if (AvroSerializationProvider.getMinorVersion() < minorVersion && log.isTraceEnabled()) {
            log.tracef("Parsing message from a future protocol version. Some feature might not be propagated. Message version: " + majorVersion + "." + minorVersion + ". Current protocol version: " + AvroSerializationProvider.getMajorVersion() + "." + AvroSerializationProvider.getMinorVersion(), new Object[0]);
        }
        byte[] newData = new byte[data.length - 2];
        System.arraycopy(data, 2, newData, 0, newData.length);
        Message message = SerializationHelper.toInstance(newData, Message.class);
        for (Operation operation : message.getOperations()) {
            Operation safeOperation;
            if (operation instanceof OptimizeAll) {
                hydrator.addOptimizeAll();
                continue;
            }
            if (operation instanceof PurgeAll) {
                safeOperation = (PurgeAll)operation;
                hydrator.addPurgeAllLuceneWork(safeOperation.getClass().getName());
                continue;
            }
            if (operation instanceof Delete) {
                safeOperation = (Delete)operation;
                hydrator.addDeleteLuceneWork(((Delete)safeOperation).getEntityClassName(), ((Delete)safeOperation).getId());
                continue;
            }
            if (operation instanceof Add) {
                safeOperation = (Add)operation;
                this.buildLuceneDocument(((Add)safeOperation).getDocument(), hydrator);
                hydrator.addAddLuceneWork(((Add)safeOperation).getEntityClassName(), ((Add)safeOperation).getId(), ((Add)safeOperation).getFieldToAnalyzerMap());
                continue;
            }
            if (!(operation instanceof Update)) continue;
            safeOperation = (Update)operation;
            this.buildLuceneDocument(((Update)safeOperation).getDocument(), hydrator);
            hydrator.addUpdateLuceneWork(((Update)safeOperation).getEntityClassName(), ((Update)safeOperation).getId(), ((Update)safeOperation).getFieldToAnalyzerMap());
        }
    }

    private void buildLuceneDocument(SerializableDocument document, LuceneWorksBuilder hydrator) {
        hydrator.defineDocument(document.getBoost());
        for (SerializableFieldable field : document.getFieldables()) {
            SerializableFieldable safeField;
            if (field instanceof SerializableCustomFieldable) {
                safeField = (SerializableCustomFieldable)field;
                hydrator.addFieldable(((SerializableCustomFieldable)safeField).getInstance());
                continue;
            }
            if (field instanceof SerializableNumericField) {
                safeField = (SerializableNumericField)field;
                if (field instanceof SerializableIntField) {
                    hydrator.addIntNumericField(((SerializableIntField)field).getValue(), ((SerializableNumericField)safeField).getName(), ((SerializableNumericField)safeField).getPrecisionStep(), ((SerializableNumericField)safeField).getStore(), ((SerializableNumericField)safeField).isIndexed(), ((SerializableNumericField)safeField).isOmitNorms(), ((SerializableNumericField)safeField).isOmitTermFreqAndPositions());
                    continue;
                }
                if (field instanceof SerializableLongField) {
                    hydrator.addLongNumericField(((SerializableLongField)field).getValue(), ((SerializableNumericField)safeField).getName(), ((SerializableNumericField)safeField).getPrecisionStep(), ((SerializableNumericField)safeField).getStore(), ((SerializableNumericField)safeField).isIndexed(), ((SerializableNumericField)safeField).isOmitNorms(), ((SerializableNumericField)safeField).isOmitTermFreqAndPositions());
                    continue;
                }
                if (field instanceof SerializableFloatField) {
                    hydrator.addFloatNumericField(((SerializableFloatField)field).getValue(), ((SerializableNumericField)safeField).getName(), ((SerializableNumericField)safeField).getPrecisionStep(), ((SerializableNumericField)safeField).getStore(), ((SerializableNumericField)safeField).isIndexed(), ((SerializableNumericField)safeField).isOmitNorms(), ((SerializableNumericField)safeField).isOmitTermFreqAndPositions());
                    continue;
                }
                if (field instanceof SerializableDoubleField) {
                    hydrator.addDoubleNumericField(((SerializableDoubleField)field).getValue(), ((SerializableNumericField)safeField).getName(), ((SerializableNumericField)safeField).getPrecisionStep(), ((SerializableNumericField)safeField).getStore(), ((SerializableNumericField)safeField).isIndexed(), ((SerializableNumericField)safeField).isOmitNorms(), ((SerializableNumericField)safeField).isOmitTermFreqAndPositions());
                    continue;
                }
                throw new SearchException("Unknown SerializableNumericField: " + field.getClass());
            }
            if (field instanceof SerializableField) {
                SerializableField reallySafeField;
                safeField = (SerializableField)field;
                if (field instanceof SerializableBinaryField) {
                    reallySafeField = (SerializableBinaryField)field;
                    hydrator.addFieldWithBinaryData(reallySafeField.getName(), ((SerializableBinaryField)reallySafeField).getValue(), ((SerializableBinaryField)reallySafeField).getOffset(), ((SerializableBinaryField)reallySafeField).getLength(), ((SerializableField)safeField).getBoost(), ((SerializableField)safeField).isOmitNorms(), ((SerializableField)safeField).isOmitTermFreqAndPositions());
                    continue;
                }
                if (field instanceof SerializableStringField) {
                    reallySafeField = (SerializableStringField)field;
                    hydrator.addFieldWithStringData(reallySafeField.getName(), ((SerializableStringField)reallySafeField).getValue(), ((SerializableStringField)reallySafeField).getStore(), ((SerializableStringField)reallySafeField).getIndex(), ((SerializableStringField)reallySafeField).getTermVector(), ((SerializableField)safeField).getBoost(), ((SerializableField)safeField).isOmitNorms(), ((SerializableField)safeField).isOmitTermFreqAndPositions());
                    continue;
                }
                if (field instanceof SerializableTokenStreamField) {
                    reallySafeField = (SerializableTokenStreamField)field;
                    hydrator.addFieldWithTokenStreamData(reallySafeField.getName(), ((SerializableTokenStreamField)reallySafeField).getValue().getStream(), ((SerializableTokenStreamField)reallySafeField).getTermVector(), ((SerializableField)safeField).getBoost(), ((SerializableField)safeField).isOmitNorms(), ((SerializableField)safeField).isOmitTermFreqAndPositions());
                    continue;
                }
                if (field instanceof SerializableReaderField) {
                    reallySafeField = (SerializableReaderField)field;
                    hydrator.addFieldWithSerializableReaderData(reallySafeField.getName(), ((SerializableReaderField)reallySafeField).getValue(), ((SerializableReaderField)reallySafeField).getTermVector(), ((SerializableField)safeField).getBoost(), ((SerializableField)safeField).isOmitNorms(), ((SerializableField)safeField).isOmitTermFreqAndPositions());
                    continue;
                }
                throw new SearchException("Unknown SerializableField: " + field.getClass());
            }
            throw new SearchException("Unknown SerializableFieldable: " + field.getClass());
        }
    }
}

