/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.indexes.serialization.codex.impl;

import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.document.NumericField;
import org.apache.lucene.util.AttributeImpl;
import org.hibernate.search.SearchException;
import org.hibernate.search.backend.AddLuceneWork;
import org.hibernate.search.backend.DeleteLuceneWork;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.OptimizeLuceneWork;
import org.hibernate.search.backend.PurgeAllLuceneWork;
import org.hibernate.search.backend.UpdateLuceneWork;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.engine.spi.EntityIndexBinder;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.indexes.serialization.codex.impl.CopyTokenStream;
import org.hibernate.search.indexes.serialization.codex.impl.SerializationHelper;
import org.hibernate.search.indexes.serialization.codex.spi.LuceneWorksBuilder;
import org.hibernate.search.indexes.serialization.operations.impl.SerializableIndex;
import org.hibernate.search.indexes.serialization.operations.impl.SerializableStore;
import org.hibernate.search.indexes.serialization.operations.impl.SerializableTermVector;
import org.hibernate.search.util.impl.ClassLoaderHelper;

public class LuceneWorkHydrator
implements LuceneWorksBuilder {
    private SearchFactoryImplementor searchFactory;
    private List<LuceneWork> results;
    private ClassLoader loader;
    private Document luceneDocument;

    public LuceneWorkHydrator(SearchFactoryImplementor searchFactory) {
        this.searchFactory = searchFactory;
        this.results = new ArrayList<LuceneWork>();
        this.loader = Thread.currentThread().getContextClassLoader();
    }

    public List<LuceneWork> getLuceneWorks() {
        return this.results;
    }

    @Override
    public void addOptimizeAll() {
        this.results.add(new OptimizeLuceneWork());
    }

    @Override
    public void addPurgeAllLuceneWork(String entityClassName) {
        Class<?> entityClass = ClassLoaderHelper.classForName(entityClassName, LuceneWorkHydrator.class, "entity class");
        this.results.add(new PurgeAllLuceneWork(entityClass));
    }

    @Override
    public void addDeleteLuceneWork(String entityClassName, byte[] idAsByte) {
        Class<?> entityClass = ClassLoaderHelper.classForName(entityClassName, LuceneWorkHydrator.class, "entity class");
        Serializable id = SerializationHelper.toSerializable(idAsByte, this.loader);
        DeleteLuceneWork result = new DeleteLuceneWork(id, this.objectIdInString(entityClass, id), entityClass);
        this.results.add(result);
    }

    @Override
    public void addAddLuceneWork(String entityClassName, byte[] idAsByte, Map<String, String> fieldToAnalyzerMap) {
        Class<?> entityClass = ClassLoaderHelper.classForName(entityClassName, LuceneWorkHydrator.class, "entity class");
        Serializable id = SerializationHelper.toSerializable(idAsByte, this.loader);
        AddLuceneWork result = new AddLuceneWork(id, this.objectIdInString(entityClass, id), entityClass, this.getLuceneDocument(), fieldToAnalyzerMap);
        this.results.add(result);
        this.clearDocument();
    }

    @Override
    public void addUpdateLuceneWork(String entityClassName, byte[] idAsByte, Map<String, String> fieldToAnalyzerMap) {
        Class<?> entityClass = ClassLoaderHelper.classForName(entityClassName, LuceneWorkHydrator.class, "entity class");
        Serializable id = SerializationHelper.toSerializable(idAsByte, this.loader);
        UpdateLuceneWork result = new UpdateLuceneWork(id, this.objectIdInString(entityClass, id), entityClass, this.getLuceneDocument(), fieldToAnalyzerMap);
        this.results.add(result);
        this.clearDocument();
    }

    private void clearDocument() {
        this.luceneDocument = null;
    }

    @Override
    public void defineDocument(float boost) {
        this.getLuceneDocument().setBoost(boost);
    }

    @Override
    public void addFieldable(byte[] instanceAsByte) {
        this.getLuceneDocument().add((Fieldable)SerializationHelper.toSerializable(instanceAsByte, this.loader));
    }

    @Override
    public void addIntNumericField(int value, String name, int precisionStep, SerializableStore store, boolean indexed, boolean omitNorms, boolean omitTermFreqAndPositions) {
        NumericField numField = new NumericField(name, precisionStep, LuceneWorkHydrator.getStore(store), indexed);
        numField.setOmitNorms(omitNorms);
        numField.setOmitTermFreqAndPositions(omitTermFreqAndPositions);
        numField.setIntValue(value);
        this.getLuceneDocument().add((Fieldable)numField);
    }

    @Override
    public void addLongNumericField(long value, String name, int precisionStep, SerializableStore store, boolean indexed, boolean omitNorms, boolean omitTermFreqAndPositions) {
        NumericField numField = new NumericField(name, precisionStep, LuceneWorkHydrator.getStore(store), indexed);
        numField.setOmitNorms(omitNorms);
        numField.setOmitTermFreqAndPositions(omitTermFreqAndPositions);
        numField.setLongValue(value);
        this.getLuceneDocument().add((Fieldable)numField);
    }

    @Override
    public void addFloatNumericField(float value, String name, int precisionStep, SerializableStore store, boolean indexed, boolean omitNorms, boolean omitTermFreqAndPositions) {
        NumericField numField = new NumericField(name, precisionStep, LuceneWorkHydrator.getStore(store), indexed);
        numField.setOmitNorms(omitNorms);
        numField.setOmitTermFreqAndPositions(omitTermFreqAndPositions);
        numField.setFloatValue(value);
        this.getLuceneDocument().add((Fieldable)numField);
    }

    @Override
    public void addDoubleNumericField(double value, String name, int precisionStep, SerializableStore store, boolean indexed, boolean omitNorms, boolean omitTermFreqAndPositions) {
        NumericField numField = new NumericField(name, precisionStep, LuceneWorkHydrator.getStore(store), indexed);
        numField.setOmitNorms(omitNorms);
        numField.setOmitTermFreqAndPositions(omitTermFreqAndPositions);
        numField.setDoubleValue(value);
        this.getLuceneDocument().add((Fieldable)numField);
    }

    @Override
    public void addFieldWithBinaryData(String name, byte[] value, int offset, int length, float boost, boolean omitNorms, boolean omitTermFreqAndPositions) {
        Field luceneField = new Field(name, value, offset, length);
        this.setCommonFieldAttributesAddAddToDocument(boost, omitNorms, omitTermFreqAndPositions, luceneField);
    }

    private void setCommonFieldAttributesAddAddToDocument(float boost, boolean omitNorms, boolean omitTermFreqAndPositions, Field luceneField) {
        luceneField.setBoost(boost);
        luceneField.setOmitNorms(omitNorms);
        luceneField.setOmitTermFreqAndPositions(omitTermFreqAndPositions);
        this.getLuceneDocument().add((Fieldable)luceneField);
    }

    @Override
    public void addFieldWithStringData(String name, String value, SerializableStore store, SerializableIndex index, SerializableTermVector termVector, float boost, boolean omitNorms, boolean omitTermFreqAndPositions) {
        Field luceneField = new Field(name, value, LuceneWorkHydrator.getStore(store), LuceneWorkHydrator.getIndex(index), LuceneWorkHydrator.getTermVector(termVector));
        this.setCommonFieldAttributesAddAddToDocument(boost, omitNorms, omitTermFreqAndPositions, luceneField);
    }

    @Override
    public void addFieldWithTokenStreamData(String name, List<List<AttributeImpl>> tokenStream, SerializableTermVector termVector, float boost, boolean omitNorms, boolean omitTermFreqAndPositions) {
        Field luceneField = new Field(name, (TokenStream)new CopyTokenStream(tokenStream), LuceneWorkHydrator.getTermVector(termVector));
        this.setCommonFieldAttributesAddAddToDocument(boost, omitNorms, omitTermFreqAndPositions, luceneField);
    }

    @Override
    public void addFieldWithSerializableReaderData(String name, byte[] valueAsByte, SerializableTermVector termVector, float boost, boolean omitNorms, boolean omitTermFreqAndPositions) {
        Reader value = (Reader)((Object)SerializationHelper.toSerializable(valueAsByte, this.loader));
        Field luceneField = new Field(name, value, LuceneWorkHydrator.getTermVector(termVector));
        this.setCommonFieldAttributesAddAddToDocument(boost, omitNorms, omitTermFreqAndPositions, luceneField);
    }

    private Document getLuceneDocument() {
        if (this.luceneDocument == null) {
            this.luceneDocument = new Document();
        }
        return this.luceneDocument;
    }

    private String objectIdInString(Class<?> entityClass, Serializable id) {
        EntityIndexBinder<?> indexBindingForEntity = this.searchFactory.getIndexBindingForEntity(entityClass);
        if (indexBindingForEntity == null) {
            throw new SearchException("Unable to find entity type metadata while deserializing: " + entityClass);
        }
        DocumentBuilderIndexedEntity<?> documentBuilder = indexBindingForEntity.getDocumentBuilder();
        return documentBuilder.objectToString(documentBuilder.getIdKeywordName(), id);
    }

    private static Field.TermVector getTermVector(SerializableTermVector termVector) {
        switch (termVector) {
            case NO: {
                return Field.TermVector.NO;
            }
            case WITH_OFFSETS: {
                return Field.TermVector.WITH_OFFSETS;
            }
            case WITH_POSITIONS: {
                return Field.TermVector.WITH_POSITIONS;
            }
            case WITH_POSITIONS_OFFSETS: {
                return Field.TermVector.WITH_POSITIONS_OFFSETS;
            }
            case YES: {
                return Field.TermVector.YES;
            }
        }
        throw new SearchException("Unable to convert serializable TermVector to Lucene TermVector: " + (Object)((Object)termVector));
    }

    private static Field.Index getIndex(SerializableIndex index) {
        switch (index) {
            case ANALYZED: {
                return Field.Index.ANALYZED;
            }
            case ANALYZED_NO_NORMS: {
                return Field.Index.ANALYZED_NO_NORMS;
            }
            case NO: {
                return Field.Index.NO;
            }
            case NOT_ANALYZED: {
                return Field.Index.NOT_ANALYZED;
            }
            case NOT_ANALYZED_NO_NORMS: {
                return Field.Index.NOT_ANALYZED_NO_NORMS;
            }
        }
        throw new SearchException("Unable to convert serializable Index to Lucene Index: " + (Object)((Object)index));
    }

    private static Field.Store getStore(SerializableStore store) {
        switch (store) {
            case NO: {
                return Field.Store.NO;
            }
            case YES: {
                return Field.Store.YES;
            }
        }
        throw new SearchException("Unable to convert serializable Store to Lucene Store: " + (Object)((Object)store));
    }
}

