/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.bridge.builtin.impl;

import java.util.zip.DataFormatException;
import org.apache.lucene.document.CompressionTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.hibernate.search.SearchException;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.bridge.TwoWayStringBridge;
import org.hibernate.search.bridge.builtin.impl.String2FieldBridgeAdaptor;

public class TwoWayString2FieldBridgeAdaptor
extends String2FieldBridgeAdaptor
implements TwoWayFieldBridge {
    private final TwoWayStringBridge stringBridge;

    public TwoWayString2FieldBridgeAdaptor(TwoWayStringBridge stringBridge) {
        super(stringBridge);
        this.stringBridge = stringBridge;
    }

    @Override
    public String objectToString(Object object) {
        return this.stringBridge.objectToString(object);
    }

    @Override
    public Object get(String name, Document document) {
        String stringValue;
        Field field = document.getField(name);
        if (field == null) {
            return this.stringBridge.stringToObject(null);
        }
        if (field.isBinary()) {
            try {
                stringValue = CompressionTools.decompressString((byte[])field.getBinaryValue());
            }
            catch (DataFormatException e) {
                throw new SearchException("Field " + name + " looks like binary but couldn't be decompressed");
            }
        } else {
            stringValue = field.stringValue();
        }
        return this.stringBridge.stringToObject(stringValue);
    }

    public TwoWayStringBridge unwrap() {
        return this.stringBridge;
    }
}

