/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.batchindexing.impl;

import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.transaction.spi.TransactionFactory;
import org.hibernate.search.batchindexing.impl.SessionAwareRunnable;
import org.hibernate.search.batchindexing.impl.StatelessSessionAwareRunnable;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;
import org.hibernate.service.jta.platform.spi.JtaPlatform;

public class OptionallyWrapInJTATransaction
implements Runnable {
    private static final Log log = LoggerFactory.make();
    private final SessionFactoryImplementor factory;
    private final SessionAwareRunnable sessionAwareRunnable;
    private final StatelessSessionAwareRunnable statelessSessionAwareRunnable;

    public OptionallyWrapInJTATransaction(SessionFactory factory, SessionAwareRunnable sessionAwareRunnable) {
        this.factory = (SessionFactoryImplementor)factory;
        this.sessionAwareRunnable = sessionAwareRunnable;
        this.statelessSessionAwareRunnable = null;
    }

    public OptionallyWrapInJTATransaction(SessionFactory factory, StatelessSessionAwareRunnable statelessSessionAwareRunnable) {
        this.factory = (SessionFactoryImplementor)factory;
        this.sessionAwareRunnable = null;
        this.statelessSessionAwareRunnable = statelessSessionAwareRunnable;
    }

    @Override
    public void run() {
        block13: {
            boolean wrapInTransaction = this.wrapInTransaction();
            if (wrapInTransaction) {
                TransactionManager transactionManager = this.getTransactionManager();
                try {
                    StatelessSession statelessSession;
                    Session session;
                    if (this.sessionAwareRunnable != null) {
                        session = this.factory.openSession();
                        statelessSession = null;
                    } else {
                        session = null;
                        statelessSession = this.factory.openStatelessSession();
                    }
                    transactionManager.begin();
                    if (this.sessionAwareRunnable != null) {
                        this.sessionAwareRunnable.run(session);
                    } else {
                        this.statelessSessionAwareRunnable.run(statelessSession);
                    }
                    transactionManager.commit();
                    if (this.sessionAwareRunnable != null) {
                        session.close();
                        break block13;
                    }
                    statelessSession.close();
                }
                catch (Throwable e) {
                    log.errorExecutingRunnableInTransaction(e);
                    try {
                        transactionManager.rollback();
                    }
                    catch (SystemException e1) {
                        log.errorRollbackingTransaction(e.getMessage(), (Exception)((Object)e1));
                    }
                }
            } else if (this.sessionAwareRunnable != null) {
                this.sessionAwareRunnable.run(null);
            } else {
                this.statelessSessionAwareRunnable.run(null);
            }
        }
    }

    private TransactionManager getTransactionManager() {
        return ((JtaPlatform)this.factory.getServiceRegistry().getService(JtaPlatform.class)).retrieveTransactionManager();
    }

    boolean wrapInTransaction() {
        TransactionFactory transactionFactory = (TransactionFactory)this.factory.getServiceRegistry().getService(TransactionFactory.class);
        if (!transactionFactory.compatibleWithJtaSynchronization()) {
            log.trace("TransactionFactory does not require a TransactionManager: don't wrap in a JTA transaction");
            return false;
        }
        TransactionManager transactionManager = this.getTransactionManager();
        if (transactionManager == null) {
            log.trace("No TransactionManager found, do not start a surrounding JTA transaction");
            return false;
        }
        try {
            if (transactionManager.getStatus() == 6) {
                log.trace("No Transaction in progress, needs to start a JTA transaction");
                return true;
            }
        }
        catch (SystemException e) {
            log.cannotGuessTransactionStatus((Exception)((Object)e));
            return false;
        }
        log.trace("Transaction in progress, no needs to start a JTA transaction");
        return false;
    }
}

