/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene.works;

import org.hibernate.search.backend.AddLuceneWork;
import org.hibernate.search.backend.DeleteLuceneWork;
import org.hibernate.search.backend.OptimizeLuceneWork;
import org.hibernate.search.backend.PurgeAllLuceneWork;
import org.hibernate.search.backend.UpdateLuceneWork;
import org.hibernate.search.backend.impl.WorkVisitor;
import org.hibernate.search.backend.impl.lucene.works.AddWorkDelegate;
import org.hibernate.search.backend.impl.lucene.works.DeleteExtWorkDelegate;
import org.hibernate.search.backend.impl.lucene.works.DeleteWorkDelegate;
import org.hibernate.search.backend.impl.lucene.works.LuceneWorkDelegate;
import org.hibernate.search.backend.impl.lucene.works.OptimizeWorkDelegate;
import org.hibernate.search.backend.impl.lucene.works.PurgeAllWorkDelegate;
import org.hibernate.search.backend.impl.lucene.works.UpdateWorkDelegate;
import org.hibernate.search.store.Workspace;

public class LuceneWorkVisitor
implements WorkVisitor<LuceneWorkDelegate> {
    private final AddWorkDelegate addDelegate;
    private final DeleteWorkDelegate deleteDelegate;
    private final UpdateWorkDelegate updateDelegate;
    private final OptimizeWorkDelegate optimizeDelegate;
    private final PurgeAllWorkDelegate purgeAllDelegate;

    public LuceneWorkVisitor(Workspace workspace) {
        this.deleteDelegate = workspace.getEntitiesInDirectory().size() == 1 ? new DeleteExtWorkDelegate(workspace) : new DeleteWorkDelegate(workspace);
        this.purgeAllDelegate = new PurgeAllWorkDelegate();
        this.addDelegate = new AddWorkDelegate(workspace);
        this.optimizeDelegate = new OptimizeWorkDelegate(workspace);
        this.updateDelegate = new UpdateWorkDelegate(workspace, this.deleteDelegate);
    }

    @Override
    public LuceneWorkDelegate getDelegate(AddLuceneWork addLuceneWork) {
        return this.addDelegate;
    }

    @Override
    public LuceneWorkDelegate getDelegate(DeleteLuceneWork deleteLuceneWork) {
        return this.deleteDelegate;
    }

    @Override
    public LuceneWorkDelegate getDelegate(OptimizeLuceneWork optimizeLuceneWork) {
        return this.optimizeDelegate;
    }

    @Override
    public LuceneWorkDelegate getDelegate(PurgeAllLuceneWork purgeAllLuceneWork) {
        return this.purgeAllDelegate;
    }

    @Override
    public LuceneWorkDelegate getDelegate(UpdateLuceneWork updateLuceneWork) {
        return this.updateDelegate;
    }
}

