/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene;

import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hibernate.search.backend.BackendFactory;
import org.hibernate.search.backend.impl.lucene.AbstractWorkspaceImpl;
import org.hibernate.search.backend.impl.lucene.WorkspaceFactory;
import org.hibernate.search.backend.impl.lucene.works.LuceneWorkVisitor;
import org.hibernate.search.batchindexing.impl.Executors;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.indexes.impl.CommonPropertiesParse;
import org.hibernate.search.indexes.impl.DirectoryBasedIndexManager;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class LuceneBackendResources {
    private static final Log log = LoggerFactory.make();
    private final LuceneWorkVisitor visitor;
    private final AbstractWorkspaceImpl workspace;
    private final ErrorHandler errorHandler;
    private final ExecutorService queueingExecutor;
    private final ExecutorService workersExecutor;
    private final int maxQueueLength;
    private final String indexName;
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.readWriteLock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock.writeLock();

    LuceneBackendResources(WorkerBuildContext context, IndexManager indexManager, Properties props) {
        this.indexName = indexManager.getIndexName();
        this.errorHandler = context.getErrorHandler();
        this.workspace = WorkspaceFactory.createWorkspace((DirectoryBasedIndexManager)indexManager, this.errorHandler, props);
        this.visitor = new LuceneWorkVisitor(this.workspace);
        this.maxQueueLength = CommonPropertiesParse.extractMaxQueueSize(this.indexName, props);
        this.queueingExecutor = Executors.newFixedThreadPool(1, "Index updates queue processor for index " + this.indexName, this.maxQueueLength);
        this.workersExecutor = BackendFactory.buildWorkersExecutor(props, this.indexName);
    }

    public ExecutorService getQueueingExecutor() {
        return this.queueingExecutor;
    }

    public ExecutorService getWorkersExecutor() {
        return this.workersExecutor;
    }

    public int getMaxQueueLength() {
        return this.maxQueueLength;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public LuceneWorkVisitor getVisitor() {
        return this.visitor;
    }

    public AbstractWorkspaceImpl getWorkspace() {
        return this.workspace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        try {
            this.flushCloseExecutor(this.queueingExecutor);
            this.flushCloseExecutor(this.workersExecutor);
        }
        finally {
            this.workspace.shutDownNow();
        }
    }

    private void flushCloseExecutor(ExecutorService executor) {
        executor.shutdown();
        try {
            executor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.interruptedWhileWaitingForIndexActivity();
            Thread.currentThread().interrupt();
        }
        if (!executor.isTerminated()) {
            log.unableToShutdownAsyncronousIndexingByTimeout(this.indexName);
        }
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public Lock getParallelModificationLock() {
        return this.readLock;
    }

    public Lock getExclusiveModificationLock() {
        return this.writeLock;
    }
}

