/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.jms;

import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.hibernate.search.SearchException;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.impl.jms.JMSBackendQueueProcessor;
import org.hibernate.search.backend.spi.BackendQueueProcessor;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.util.impl.JNDIHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class JMSBackendQueueProcessorFactory
implements BackendQueueProcessor {
    private String jmsQueueName;
    private String jmsConnectionFactoryName;
    private static final String JNDI_PREFIX = "worker.jndi.";
    private Properties properties;
    private Queue jmsQueue;
    private QueueConnectionFactory factory;
    private String indexName;
    private SearchFactoryImplementor searchFactory;
    public static final String JMS_CONNECTION_FACTORY = "worker.jms.connection_factory";
    public static final String JMS_QUEUE = "worker.jms.queue";
    private IndexManager indexManager;
    private static final Log log = LoggerFactory.make();

    @Override
    public void initialize(Properties props, WorkerBuildContext context, IndexManager indexManager) {
        this.properties = props;
        this.indexManager = indexManager;
        this.jmsConnectionFactoryName = props.getProperty(JMS_CONNECTION_FACTORY);
        this.jmsQueueName = props.getProperty(JMS_QUEUE);
        this.indexName = indexManager.getIndexName();
        this.searchFactory = context.getUninitializedSearchFactory();
        this.prepareJMSTools();
    }

    public QueueConnectionFactory getJMSFactory() {
        return this.factory;
    }

    public Queue getJmsQueue() {
        return this.jmsQueue;
    }

    public String getJmsQueueName() {
        return this.jmsQueueName;
    }

    public void prepareJMSTools() {
        if (this.jmsQueue != null && this.factory != null) {
            return;
        }
        try {
            InitialContext initialContext = JNDIHelper.getInitialContext(this.properties, JNDI_PREFIX);
            this.factory = (QueueConnectionFactory)initialContext.lookup(this.jmsConnectionFactoryName);
            this.jmsQueue = (Queue)initialContext.lookup(this.jmsQueueName);
        }
        catch (NamingException e) {
            throw new SearchException("Unable to lookup Search queue (" + (this.jmsQueueName != null ? this.jmsQueueName : "null") + ") and connection factory (" + (this.jmsConnectionFactoryName != null ? this.jmsConnectionFactoryName : "null") + ")", e);
        }
    }

    public SearchFactoryImplementor getSearchFactory() {
        return this.searchFactory;
    }

    @Override
    public void close() {
    }

    @Override
    public void applyWork(List<LuceneWork> workList) {
        JMSBackendQueueProcessor operation = new JMSBackendQueueProcessor(this.indexName, workList, this.indexManager, this);
        operation.run();
    }

    @Override
    public void applyStreamWork(LuceneWork singleOperation) {
        this.applyWork(Collections.singletonList(singleOperation));
    }

    @Override
    public Lock getExclusiveWriteLock() {
        log.warnSuspiciousBackendDirectoryCombination(this.indexName);
        return new ReentrantLock();
    }
}

