/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.jgroups;

import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.impl.jgroups.JGroupsBackendQueueProcessor;
import org.hibernate.search.backend.impl.jgroups.JGroupsBackendQueueProcessorFactory;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class SlaveJGroupsBackendQueueProcessorFactory
extends JGroupsBackendQueueProcessorFactory {
    private static final Log log = LoggerFactory.make();
    private JGroupsBackendQueueProcessor jgroupsProcessor;

    @Override
    public void initialize(Properties props, WorkerBuildContext context, IndexManager indexManager) {
        super.initialize(props, context, indexManager);
        this.jgroupsProcessor = new JGroupsBackendQueueProcessor(this, indexManager);
    }

    @Override
    public void applyWork(List<LuceneWork> workList) {
        this.jgroupsProcessor.sendLuceneWorkList(workList);
    }

    @Override
    public void applyStreamWork(LuceneWork singleOperation) {
        this.jgroupsProcessor.sendLuceneWorkList(Collections.singletonList(singleOperation));
    }

    @Override
    public Lock getExclusiveWriteLock() {
        log.warnSuspiciousBackendDirectoryCombination(this.indexName);
        return new ReentrantLock();
    }
}

