/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl;

import java.io.Serializable;
import javax.transaction.Synchronization;
import javax.transaction.TransactionManager;
import org.hibernate.HibernateException;
import org.hibernate.action.spi.AfterTransactionCompletionProcess;
import org.hibernate.action.spi.BeforeTransactionCompletionProcess;
import org.hibernate.engine.spi.ActionQueue;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.FlushEventListener;
import org.hibernate.search.SearchException;
import org.hibernate.search.backend.TransactionContext;
import org.hibernate.search.event.impl.FullTextIndexEventListener;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;
import org.hibernate.service.Service;
import org.hibernate.service.jta.platform.spi.JtaPlatform;

public class EventSourceTransactionContext
implements TransactionContext,
Serializable {
    private static final Log log = LoggerFactory.make();
    private final EventSource eventSource;
    private transient FullTextIndexEventListener flushListener;
    private Boolean realTxInProgress = null;

    public EventSourceTransactionContext(EventSource eventSource) {
        this.eventSource = eventSource;
        this.flushListener = this.getIndexWorkFlushEventListener();
    }

    @Override
    public Object getTransactionIdentifier() {
        if (this.isRealTransactionInProgress()) {
            return this.eventSource.getTransaction();
        }
        return this.eventSource;
    }

    @Override
    public void registerSynchronization(Synchronization synchronization) {
        if (this.isRealTransactionInProgress()) {
            ActionQueue actionQueue = this.eventSource.getActionQueue();
            boolean isLocal = this.isLocalTransaction();
            if (isLocal) {
                actionQueue.registerProcess((BeforeTransactionCompletionProcess)new DelegateToSynchronizationOnBeforeTx(synchronization));
            } else {
                actionQueue.registerProcess((BeforeTransactionCompletionProcess)new DelegateToSynchronizationOnBeforeTx(synchronization));
                this.eventSource.getTransaction().registerSynchronization((Synchronization)new BeforeCommitSynchronizationDelegator(synchronization));
            }
            actionQueue.registerProcess((AfterTransactionCompletionProcess)new DelegateToSynchronizationOnAfterTx(synchronization));
        } else {
            this.flushListener = this.getIndexWorkFlushEventListener();
            if (this.flushListener != null) {
                this.flushListener.addSynchronization(this.eventSource, synchronization);
            } else {
                throw new SearchException("AssertionFailure: flushListener not registered any more.");
            }
        }
    }

    private boolean isLocalTransaction() {
        TransactionManager transactionManager = this.getService(JtaPlatform.class).retrieveTransactionManager();
        return transactionManager == null;
    }

    private <T extends Service> T getService(Class<T> serviceClass) {
        return (T)this.eventSource.getFactory().getServiceRegistry().getService(serviceClass);
    }

    private FullTextIndexEventListener getIndexWorkFlushEventListener() {
        if (this.flushListener != null) {
            return this.flushListener;
        }
        Iterable listeners = this.getService(EventListenerRegistry.class).getEventListenerGroup(EventType.FLUSH).listeners();
        for (FlushEventListener listener : listeners) {
            if (!FullTextIndexEventListener.class.isAssignableFrom(listener.getClass())) continue;
            return (FullTextIndexEventListener)listener;
        }
        log.debug("FullTextIndexEventListener was not registered as FlushEventListener");
        return null;
    }

    @Override
    public boolean isTransactionInProgress() {
        return this.getIndexWorkFlushEventListener() != null || this.isRealTransactionInProgress();
    }

    private boolean isRealTransactionInProgress() {
        if (this.realTxInProgress == null) {
            this.realTxInProgress = this.eventSource.isTransactionInProgress();
        }
        return this.realTxInProgress;
    }

    private static class BeforeCommitSynchronizationDelegator
    implements Synchronization {
        private final Synchronization synchronization;

        public BeforeCommitSynchronizationDelegator(Synchronization sync) {
            this.synchronization = sync;
        }

        public void beforeCompletion() {
            this.synchronization.beforeCompletion();
        }

        public void afterCompletion(int status) {
        }
    }

    private static class DelegateToSynchronizationOnAfterTx
    implements AfterTransactionCompletionProcess {
        private final Synchronization synchronization;

        DelegateToSynchronizationOnAfterTx(Synchronization synchronization) {
            this.synchronization = synchronization;
        }

        public void doAfterTransactionCompletion(boolean success, SessionImplementor sessionImplementor) {
            try {
                this.synchronization.afterCompletion(success ? 3 : 4);
            }
            catch (Exception e) {
                throw new HibernateException("Error while indexing in Hibernate Search (ater transaction completion)", (Throwable)e);
            }
        }
    }

    private static class DelegateToSynchronizationOnBeforeTx
    implements BeforeTransactionCompletionProcess {
        private final Synchronization synchronization;

        DelegateToSynchronizationOnBeforeTx(Synchronization synchronization) {
            this.synchronization = synchronization;
        }

        public void doBeforeTransactionCompletion(SessionImplementor sessionImplementor) {
            try {
                this.synchronization.beforeCompletion();
            }
            catch (Exception e) {
                throw new HibernateException("Error while indexing in Hibernate Search (before transaction completion)", (Throwable)e);
            }
        }
    }
}

