/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend;

import java.util.Properties;
import java.util.concurrent.ExecutorService;
import org.hibernate.annotations.common.util.StringHelper;
import org.hibernate.search.backend.impl.blackhole.BlackHoleBackendQueueProcessorFactory;
import org.hibernate.search.backend.impl.jgroups.MasterJGroupsBackendQueueProcessorFactory;
import org.hibernate.search.backend.impl.jgroups.SlaveJGroupsBackendQueueProcessorFactory;
import org.hibernate.search.backend.impl.jms.JMSBackendQueueProcessorFactory;
import org.hibernate.search.backend.impl.lucene.LuceneBackendQueueProcessorFactory;
import org.hibernate.search.backend.spi.BackendQueueProcessor;
import org.hibernate.search.batchindexing.impl.Executors;
import org.hibernate.search.indexes.serialization.codex.avro.impl.AvroSerializationProvider;
import org.hibernate.search.indexes.serialization.codex.impl.PluggableSerializationLuceneWorkSerializer;
import org.hibernate.search.indexes.serialization.codex.spi.LuceneWorkSerializer;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.util.configuration.impl.ConfigurationParseHelper;
import org.hibernate.search.util.impl.ClassLoaderHelper;

public class BackendFactory {
    public static BackendQueueProcessor createBackend(IndexManager indexManager, WorkerBuildContext context, Properties properties) {
        String backend = properties.getProperty("worker.backend");
        BackendQueueProcessor backendQueueProcessorFactory = StringHelper.isEmpty((String)backend) || "lucene".equalsIgnoreCase(backend) ? new LuceneBackendQueueProcessorFactory() : ("jms".equalsIgnoreCase(backend) ? new JMSBackendQueueProcessorFactory() : ("blackhole".equalsIgnoreCase(backend) ? new BlackHoleBackendQueueProcessorFactory() : ("jgroupsMaster".equals(backend) ? new MasterJGroupsBackendQueueProcessorFactory() : ("jgroupsSlave".equals(backend) ? new SlaveJGroupsBackendQueueProcessorFactory() : ClassLoaderHelper.instanceFromName(BackendQueueProcessor.class, backend, BackendFactory.class, "processor")))));
        backendQueueProcessorFactory.initialize(properties, context, indexManager);
        return backendQueueProcessorFactory;
    }

    public static boolean isConfiguredAsSync(Properties properties) {
        return !"async".equalsIgnoreCase(properties.getProperty("worker.execution"));
    }

    public static ExecutorService buildWorkersExecutor(Properties properties, String indexManagerName) {
        int threadPoolSize = BackendFactory.getWorkerThreadPoolSize(properties);
        int queueSize = BackendFactory.getWorkerQueueSize(properties);
        return Executors.newFixedThreadPool(threadPoolSize, "IndexWriter worker executor for " + indexManagerName, queueSize);
    }

    public static int getWorkerThreadPoolSize(Properties properties) {
        return ConfigurationParseHelper.getIntValue(properties, "worker.thread_pool.size", 1);
    }

    public static int getWorkerQueueSize(Properties properties) {
        return ConfigurationParseHelper.getIntValue(properties, "worker.buffer_queue.max", Integer.MAX_VALUE);
    }

    public static int getWorkerBatchSize(Properties properties) {
        return ConfigurationParseHelper.getIntValue(properties, "hibernate.search.batch_size", 0);
    }

    public static LuceneWorkSerializer createSerializer(String indexName, Properties cfg, WorkerBuildContext buildContext) {
        return new PluggableSerializationLuceneWorkSerializer(new AvroSerializationProvider(), buildContext.getUninitializedSearchFactory());
    }
}

