/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.batchindexing;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;
import org.hibernate.Transaction;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.search.batchindexing.Helper;
import org.hibernate.search.batchindexing.MassIndexerProgressMonitor;
import org.hibernate.search.batchindexing.ProducerConsumerQueue;
import org.hibernate.search.batchindexing.StatelessSessionAwareRunnable;
import org.hibernate.search.util.LoggerFactory;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentifierProducer
implements StatelessSessionAwareRunnable {
    private static final Logger log = LoggerFactory.make();
    private final ProducerConsumerQueue<List<Serializable>> destination;
    private final SessionFactory sessionFactory;
    private final int batchSize;
    private final Class<?> indexedType;
    private final MassIndexerProgressMonitor monitor;
    private final long objectsLimit;

    public IdentifierProducer(ProducerConsumerQueue<List<Serializable>> fromIdentifierListToEntities, SessionFactory sessionFactory, int objectLoadingBatchSize, Class<?> indexedType, MassIndexerProgressMonitor monitor, long objectsLimit) {
        this.destination = fromIdentifierListToEntities;
        this.sessionFactory = sessionFactory;
        this.batchSize = objectLoadingBatchSize;
        this.indexedType = indexedType;
        this.monitor = monitor;
        this.objectsLimit = objectsLimit;
        log.trace("created");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(StatelessSession upperSession) {
        log.trace("started");
        try {
            this.inTransactionWrapper(upperSession);
        }
        catch (Throwable e) {
            log.error("error during batch indexing: ", e);
        }
        finally {
            this.destination.producerStopping();
        }
        log.trace("finished");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void inTransactionWrapper(StatelessSession upperSession) throws Exception {
        StatelessSession session = upperSession;
        if (upperSession == null) {
            session = this.sessionFactory.openStatelessSession();
        }
        try {
            Transaction transaction = Helper.getTransactionAndMarkForJoin(session);
            transaction.begin();
            this.loadAllIdentifiers(session);
            transaction.commit();
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            if (upperSession == null) {
                session.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAllIdentifiers(StatelessSession session) throws InterruptedException {
        Number countAsNumber = (Number)session.createCriteria(this.indexedType).setProjection(Projections.rowCount()).setCacheable(false).uniqueResult();
        long totalCount = countAsNumber.longValue();
        if (this.objectsLimit != 0L && this.objectsLimit < totalCount) {
            totalCount = this.objectsLimit;
        }
        log.debug("going to fetch {} primary keys", (Object)totalCount);
        this.monitor.addToTotalCount(totalCount);
        Criteria criteria = session.createCriteria(this.indexedType).setProjection((Projection)Projections.id()).setCacheable(false).setFetchSize(100);
        ScrollableResults results = criteria.scroll(ScrollMode.FORWARD_ONLY);
        ArrayList<Serializable> destinationList = new ArrayList<Serializable>(this.batchSize);
        long counter = 0L;
        try {
            while (results.next()) {
                Serializable id = (Serializable)results.get(0);
                destinationList.add(id);
                if (destinationList.size() == this.batchSize) {
                    this.enqueueList(destinationList);
                    destinationList = new ArrayList(this.batchSize);
                }
                if (++counter != totalCount) continue;
                break;
            }
        }
        finally {
            results.close();
        }
        this.enqueueList(destinationList);
    }

    private void enqueueList(List<Serializable> idsList) throws InterruptedException {
        if (!idsList.isEmpty()) {
            this.destination.put(idsList);
            log.trace("produced a list of ids {}", idsList);
        }
    }
}

