/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene.works;

import java.io.Serializable;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.search.SearchException;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.Workspace;
import org.hibernate.search.backend.impl.lucene.works.DeleteWorkDelegate;
import org.hibernate.search.bridge.util.NumericFieldUtils;
import org.hibernate.search.engine.DocumentBuilderIndexedEntity;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.util.LoggerFactory;
import org.slf4j.Logger;

public class DeleteExtWorkDelegate
extends DeleteWorkDelegate {
    private final Class<?> managedType;
    private final DocumentBuilderIndexedEntity<?> builder;
    private final Logger log = LoggerFactory.make();
    private final boolean idIsNumeric;

    DeleteExtWorkDelegate(Workspace workspace, WorkerBuildContext context) {
        super(workspace);
        this.managedType = workspace.getEntitiesInDirectory().iterator().next();
        this.builder = context.getDocumentBuilderIndexedEntity(this.managedType);
        this.idIsNumeric = DeleteExtWorkDelegate.isIdNumeric(this.managedType, this.builder);
    }

    public void performWork(LuceneWork work, IndexWriter writer) {
        this.checkType(work);
        Serializable id = work.getId();
        this.log.trace("Removing {}#{} by id using an IndexWriter.", this.managedType, (Object)id);
        try {
            if (this.idIsNumeric) {
                writer.deleteDocuments(NumericFieldUtils.createExactMatchQuery(this.builder.getIdKeywordName(), id));
            } else {
                Term idTerm = this.builder.getTerm(id);
                writer.deleteDocuments(idTerm);
            }
        }
        catch (Exception e) {
            String message = "Unable to remove " + this.managedType + "#" + id + " from index.";
            throw new SearchException(message, e);
        }
    }

    private void checkType(LuceneWork work) {
        if (work.getEntityClass() != this.managedType) {
            throw new AssertionFailure("Unexpected type");
        }
    }
}

