/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.configuration;

import java.io.Serializable;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.LogByteSizeMergePolicy;
import org.hibernate.search.backend.configuration.ConfigurationParseHelper;
import org.hibernate.search.util.LoggerFactory;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum IndexWriterSetting implements Serializable
{
    MAX_BUFFERED_DELETE_TERMS("max_buffered_delete_terms"){

        public void applySetting(IndexWriterConfig writerConfig, int value) {
            writerConfig.setMaxBufferedDeleteTerms(value);
        }
    }
    ,
    MAX_BUFFERED_DOCS("max_buffered_docs"){

        public void applySetting(IndexWriterConfig writerConfig, int value) {
            writerConfig.setMaxBufferedDocs(value);
        }
    }
    ,
    MAX_FIELD_LENGTH("max_field_length"){

        public void applySetting(IndexWriterConfig writerConfig, int value) {
            log.warn("Configuration option 'max_field_length' is no longer applied. Use LimitTokenCountAnalyzer instead");
        }
    }
    ,
    MAX_MERGE_DOCS("max_merge_docs"){

        public void applySetting(LogByteSizeMergePolicy logByteSizeMergePolicy, int value) {
            logByteSizeMergePolicy.setMaxMergeDocs(value);
        }
    }
    ,
    MERGE_FACTOR("merge_factor"){

        public void applySetting(LogByteSizeMergePolicy logByteSizeMergePolicy, int value) {
            logByteSizeMergePolicy.setMergeFactor(value);
        }
    }
    ,
    RAM_BUFFER_SIZE("ram_buffer_size"){

        public void applySetting(IndexWriterConfig writerConfig, int value) {
            writerConfig.setRAMBufferSizeMB((double)value);
        }
    }
    ,
    TERM_INDEX_INTERVAL("term_index_interval"){

        public void applySetting(IndexWriterConfig writerConfig, int value) {
            writerConfig.setTermIndexInterval(value);
        }
    }
    ,
    USE_COMPOUND_FILE("use_compound_file"){

        public Integer parseVal(String value) {
            return 8.USE_COMPOUND_FILE.parseBoolean(value);
        }

        public void applySetting(LogByteSizeMergePolicy logByteSizeMergePolicy, int value) {
            boolean useCompoundFile = IndexWriterSetting.intToBoolean(value);
            logByteSizeMergePolicy.setUseCompoundFile(useCompoundFile);
        }
    };

    private static final Logger log;
    private static final Integer TRUE;
    private static final Integer FALSE;
    private final String cfgKey;

    private IndexWriterSetting(String configurationKey) {
        this.cfgKey = configurationKey;
    }

    public void applySetting(IndexWriterConfig writerConfig, int value) {
    }

    public void applySetting(LogByteSizeMergePolicy logByteSizeMergePolicy, int value) {
    }

    public String getKey() {
        return this.cfgKey;
    }

    public Integer parseVal(String value) {
        return ConfigurationParseHelper.parseInt(value, "Invalid value for " + this.cfgKey + ": " + value);
    }

    private Integer parseBoolean(String value) {
        boolean v = ConfigurationParseHelper.parseBoolean(value, "Invalid value for " + this.cfgKey + ": " + value);
        return v ? TRUE : FALSE;
    }

    private static boolean intToBoolean(int value) {
        return value == TRUE;
    }

    static {
        log = LoggerFactory.make();
        TRUE = 1;
        FALSE = 0;
    }
}

